
(* -------------------------------------------------------------------- *)
(*									*)
(*		Test3.ml						*)	
(*									*)
(* -------------------------------------------------------------------- *)

print "\n\n Test3.ml\n\n";
print "\n\n Scope Rules and Arithmetic\n\n";

(* -------------------------------------------------------------------- *)
(*      Two examples showing the different effect of 			*)
(*	sequential and parallel composition				*)
(* -------------------------------------------------------------------- *)

exp_eval E "let val var x = scon m in \
\          let val var x = scon n; val var y = var x in var y end end";	

exp_eval E "let val var x = scon m in \
\         let val var x = scon n and var y = var x in var y end end";

(* -------------------------------------------------------------------- *)
(*		example showing that static binding is assumed		*)
(* -------------------------------------------------------------------- *)

exp_eval E "let val var y = scon m in \
\               let val var x = var y in let val var y \
\      = scon n in var x end end end";

(* -------------------------------------------------------------------- *)
(* 	swap routine 							*)
(* -------------------------------------------------------------------- *)

dec_eval E "val var t = var x; val var x = var z; val var z = var t";

exp_eval E "let val var t = var x; val var x = var z; val var z = var t \
\  in var x end";

(* -------------------------------------------------------------------- *)
(* 	Arithmetic operations 						*)
(* -------------------------------------------------------------------- *)

exp_eval E "var x + var z";

exp_eval E "var x - var z";

exp_eval E "var x * var z";


