(* -------------------------------------------------------------------- *)
(*									*)
(*		Test1.ml						*)
(*									*)
(* -------------------------------------------------------------------- *)

print "\n\n Test Suite 1\n\n";
print "\n\n Bare Language Phrases\n\n";

(* Examples of expression evaluation *)

exp_eval E "scon n";

exp_eval E " var x";

exp_eval E "var y";

exp_eval E "con true";

exp_eval E "con q"; 

exp_eval E "{age =  var x, height =  var z}";

exp_eval E "let val var y = scon m in var  y end";

exp_eval E "let val var x = scon m; val var y = scon n in var y end";

Obj.show_envs := true;

dec_eval E " nothing";

dec_eval E " val var x = scon m";

dec_eval E "val var z = var y";

dec_eval E "local val var z = var y in val var q = var z end";

dec_eval E "val var x = scon m; val var y = scon n";

dec_eval E "val var x = scon m val var y = scon n";

dec_eval E "val (- var x, var y -) = (- scon m, scon n -)";

dec_eval E "val var x = scon m and var z = scon k";

Obj.show_envs := false;
