(* -------------------------------------------------------------------- *)
(*									*)
(*		Example proofs of programs 				*)
(*		This is the main test file				*)
(*									*)
(* -------------------------------------------------------------------- *)

System.Control.primaryPrompt := "ELLE > ";
System.Control.secondaryPrompt := "more.. >";

print "\n\n Evaluation: Verification of Example Programs \n\n";

Pretty.setmargin 80;
goals_limit := 10;
print_depth 0;


open System.Timer;
open Eval;
open Prover;

(* simplify the printing of syntax and values *)

SML_Syntax.show_full_syntax := false;
Obj.show_full_values := false;

val start = start_timer();

(* start with a very simple environment, and display it during proofs *)


val E = "<{| |},                                           \
     \    {|      (var x,num m),                           \
     \            (var y, <con true>),                     \
     \            (var z, num n)  |},                      \
     \    {|  |}>";


Obj.show_envs := true;

use "Test1.ml";


(* the remaining test files use a larger initial environment, which we
don't bother to display *)

Obj.show_envs := false;

val E = "<{| |},                                           \
     \    {|      (var plus, val plus),                    \
     \            (var minus, val minus),                  \
     \            (var times, val times),                  \
     \            (var less, val less),                    \
     \            (var zero, val zero),                    \
     \            (var not, val not),                      \
     \            (var head, val head),                    \
     \            (var tail, val tail),                    \
     \            (var null, val null),  		   \
     \            (var x,num m),                           \
     \            (var y, <con true>),                     \
     \            (var z, num n),                          \
     \            (var L, [num a, num b, num c]) |},       \
     \    {|  |}>";

map use ["Test2.ml", "Test3.ml", "Test4.ml", "Test5.ml"];

val non_gc_time = check_timer start;
val gc_time = check_timer_gc start;
val total_time = add_time (non_gc_time, gc_time);
print_depth 10;
print ("\n\n\nAll examples successfully \ 
      \ verified in : " ^(makestring total_time)^" seconds\n\n\n\n");

