(* ------------------------------------------------------------ *)
(*								*)
(*	 ROOT.ml:  root file for Evaluation			*)
(*	 							*)
(* ------------------------------------------------------------ *)

writeln "Root File for Functional Language Verifier";

print_depth 1; 
  
use "Obj.ml"; 

use "ObjRule.ml"; 

use "AtExp.ml";
use "ExpRow.ml";
use "Exp.ml";
use "Match.ml";
use "Mrule.ml";
use "Dec.ml";
use "ValBind.ml";
use "AtPat.ml";
use "PatRow.ml";
use "Pat.ml";
use "Program.ml";

use "Merge.ml"; 

use "DRule.ml"; 
use "Prover.ml";

structure Obj =  ObjFun (SML_Syntax);

structure ObjRule = ObjRuleFun 
     (structure Obj = Obj and SML_Syntax=SML_Syntax);

structure AtExp   = AtExpFun (structure Obj =  Obj);
structure ExpRow  = ExpRowFun (structure AtExp =  AtExp);
structure Exp     = ExpFun (structure ExpRow =  ExpRow);
structure Match   = MatchFun (structure Exp =  Exp);
structure Mrule   = MruleFun (structure Match =  Match);
structure Dec     = DecFun (structure Mrule =  Mrule);
structure ValBind = ValBindFun (structure Dec =  Dec);
structure AtPat   = AtPatFun (structure ValBind =  ValBind);
structure PatRow  = PatRowFun (structure AtPat =  AtPat);
structure Pat     = PatFun (structure PatRow =  PatRow);
structure Program = ProgramFun (structure Pat =  Pat);

structure Merge = MergeFun 
 (structure ObjRule = ObjRule and Program =  Program);

structure DRule = DRuleFun 
 (structure Merge = Merge and
            ObjRule  = ObjRule and
            AtExp =  AtExp and
            ExpRow =  ExpRow and
            Exp =  Exp and
            Match =  Match and
            Mrule =  Mrule and
            Dec =  Dec and
            ValBind =  ValBind and
            AtPat =  AtPat and
            PatRow = PatRow  and
            Program =  Program and 
            Tools = Tools);

structure Prover = ProverFun
   (structure DRule=DRule);

structure Eval =
struct
   structure Obj =  Obj
   structure ObjRule =  ObjRule
   structure AtExp =  AtExp
   structure ExpRow  = ExpRow
   structure Exp     = Exp
   structure Match   = Match
   structure Mrule   = Mrule
   structure Dec     = Dec
   structure ValBind = ValBind
   structure AtPat   = AtPat
   structure PatRow  = PatRow
   structure Pat     = Pat
   structure Program = Program
   structure Merge = Merge
   structure DRule = DRule
   structure Prover = Prover
end;

(*  (exportML "EVAL"; print "Evaluation\n");  *)



