(* -------------------------------------------------------------*)
(*								*)
(*		Program.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature PROGRAM =
  sig
   structure Pat: PAT
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor ProgramFun 
 (structure Pat : PAT) : PROGRAM =  
struct
structure Pat = Pat;
local open Syntax 
in

val spec =
    [("Program1", 					(* Rule 196a *)
	"(EX E1. E ||- dec ~> E1 in1Env' & Combine (E,E1,E') ) <-> \
      \     E ||- dec ; ~> E' [Program] "),
     ("Program2", 					(* Rule 196b *)
	"(EX E1. E ||- dec ~> E1 in1Env' & Combine (E,E1,E') & \
	\   E' ||- program ~> E'' [Program] ) <->  \
	\   E ||- dec ; program ~> E'' [Program]")];
				              (* Rules 153-159 omitted *)


val thy = extend_theory Pat.thy "PROGRAM"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
