(* -------------------------------------------------------------*)
(*								*)
(*		PatRow.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature PATROW =
  sig
   structure AtPat: ATPAT
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor PatRowFun 
 (structure AtPat : ATPAT) : PATROW =  
struct
structure AtPat = AtPat;
local open Syntax 
in

val spec =
    [("Wild_PatRow",				(* Rule 150 *)
        "VE' = {| |}  in1VarEnv' <-> E, r ||- ... ~> VE' [PatRow]"),
     ("PatRow1",					(* Rule 151a *)
        "((EX v. record_lookup (lab, r, v) &  \
       \   E, v ||- pat ~>  VE' [Pat] & VE' = FAIL in2VarEnv') |  \
       \  (EX VE v. record_lookup (lab, r, v) &                    \
       \   E, v ||- pat ~> VE' [Pat] & VE' = VE in1VarEnv')) <->   \ 
       \   E, r ||- lab = pat ~> VE'  [PatRow] "),
     ("PatRow2",					(* Rules 151.152 *)
        "((EX v. record_lookup (lab, r, v) &  \
       \  E, v ||- pat ~>  VE' [Pat] & VE' = FAIL in2VarEnv') | \
       \  (EX v VE VE1. record_lookup (lab, r, v) &   \
       \   E, v ||- pat ~> VE  in1VarEnv' [Pat] & \
       \   E, r ||- patrow ~> VE1  in1VarEnv' [PatRow] & \
       \     combine (VE, VE1, VE'')  & VE' = VE''  in1VarEnv') |  \
       \  (EX v VE. record_lookup (lab, r, v) &  \
       \    E, v ||- pat ~> VE  in1VarEnv' [Pat] & \
       \    E, r ||- patrow ~>  VE' [PatRow] &  VE' = FAIL in2VarEnv' )) <-> \
       \ E, r ||- lab = pat, patrow ~>  VE' [PatRow] ")];


val thy = extend_theory AtPat.thy "PATROW"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
