(* -------------------------------------------------------------*)
(*								*)
(*		Pat.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature PAT =
  sig
   structure PatRow: PATROW
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor PatFun 
 (structure PatRow : PATROW) : PAT =  
struct
structure PatRow = PatRow;
local open Syntax 
in

val spec =					(* Rule 42 not needed *)
    [("Con_Val_Pat",				(* Rule 154 *)
	"((E, v' ||- atpat ~> VE' [Pat] & VE' = VE  in1VarEnv') |  \
       \  (E, v' ||- atpat ~>  VE' [Pat] & VE' = FAIL in2VarEnv')) <-> \
       \  E, <con c,v'> ||- con c`atpat ~> VE' [Pat]"), 
     ("ExCon_Val_Pat",				(* Rule 156 *)
	"((EX VE VE1 SE EE. lookup (excon e, VE1, <exname en>) & \
	\  E, v' ||- atpat ~> VE' [Pat] & VE' = VE  in1VarEnv' & \
        \  E = <SE,VE1,EE>) |  \
	\ (EX VE VE1 SE EE. lookup (excon e, VE1, <exname en>) & \
       \   E, v' ||- atpat ~>  VE' [Pat] & VE' = FAIL in2VarEnv' & \
       \   E = <SE,VE1,EE>)) <-> \
       \  E, <exname en, v'> ||- con c`atpat ~> VE' [Pat]")];

val thy = extend_theory PatRow.thy "PAT"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
