(* -------------------------------------------------------------*)
(*		ObjRule.ml:					*)
(*	 Inference Rules for Semantic Objects			*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature OBJRULE =
  sig
  structure SML_Syntax : SML_SYNTAX and  Obj: OBJ
  val sign: Sign.sg
  val thy: theory
  val iff_subst_spec : (string * string) list
  val congs_spec :  (string * string) list
  val lookup_spec :  (string * string) list
  val delete_spec : (string * string) list
  val combine_spec : (string * string) list
  val Combine_spec : (string * string) list
  val unfold_spec : (string * string) list
  val record_lookup_spec : (string * string) list
  val VE0_spec : (string * string) list
  val arith_spec : (string * string) list
  val apply_spec : (string * string) list
end;

functor ObjRuleFun 
 (structure SML_Syntax : SML_SYNTAX and Obj : OBJ) : OBJRULE =  
struct
structure SML_Syntax = SML_Syntax;
structure Obj = Obj;
local open Syntax 
in

(* -------------------------------------------------------------*)
(*		Inference Rules for Semantic Domains		*)
(* ------------------------------------------------------------ *)

val iff_subst_spec =
    [("iff_subst",  "[| a <-> b; P(b) |] ==> P(a)")];

val congs_spec =
    [("lookup_cong",  "[| (id = id'); (VE = VE'); (v = v') |] ==> \
         \  lookup (id, VE, v) <-> lookup (id', VE', v')"),
     ("tr_cong",  "a <-> b ==>  tr a = tr b")];

val lookup_spec = 
    [("lookup1_rule", 	
         " lookup (id, {| (id,v) |}, v)"),
     ("lookup2_rule", 	
         " lookup (id, {| (id,v), idvalseq |}, v)"),
     ("lookup3_rule", 	
         " lookup (id, {| idvalseq |}, v) ==> \
     \     lookup (id, {| (id',w), idvalseq |}, v)") ];

val delete_spec =
    [("delete1_rule",
        "delete (id, {| |}, {| |})"),
     ("delete2_rule",
        "delete (id, {| (id,v) |}, {| |})"),
     ("delete3_rule",
        "delete (id, {| (id',v) |}, {| (id',v) |})"),
     ("delete4_rule",
        "delete (id, {| idvalseq |}, VE) ==> \
     \      delete (id, {| (id , v), idvalseq |}, VE)"),
     ("delete5_rule",
        "delete (id, {| idvalseq |}, {| idvalseq' |}) ==> \
     \      delete (id, {| (id' , v), idvalseq |}, \
     \                  {| (id', v), idvalseq' |})")];


val combine_spec =
    [("combine1_rule",
        "combine (VE, {| |}, VE)"),
     ("combine2_rule",
        "combine ({| |}, VE, VE)"),
     ("combine3_rule",
        "combine ({| |}, {| (id,v) |}, {| (id,v) |})"),
     ("combine4_rule",
        "combine ({| (id,v) |}, {| |}, {| (id,v) |})"),
     ("combine5_rule",
        "combine ({| (id,v) |}, {| (id,v') |}, {| (id,v') |})"),
     ("combine6_rule",
        "combine ({| (id,v) |}, {| (id',v') |}, {| (id',v'), (id,v) |})"),
     ("combine7_rule",
        "delete (id, {| idvalseq |}, {| idvalseq' |}) ==> \
        \ combine ({| idvalseq |}, {| (id,v) |}, {| (id,v),idvalseq' |})"),
     ("combine8_rule",
        "[| combine (VE, {| idvalseq |}, VE'); \
         \  combine (VE', {| (id,v) |}, VE'') |] ==> \
         \  combine (VE, {| (id,v), idvalseq |}, VE'')") ];

val Combine_spec =
   [("Combine1_rule",
      "[| combine (VE,VE',VE'');  combine (EE, EE', EE'') |] ==> \
       \ Combine (<SE, VE, EE>, <SE, VE', EE'>,  \
       \          <SE, VE'', EE''>)")];

val unfold_spec = 
    [("unfold1_rule",
        "unfold (VE, {| |},{| |})"),
     ("unfold2_rule",
        "unfold (VE, {| (f, closure (match,E,VE')) |}, \
       \ {| (f, closure (match,E,VE)) |}) "),
     ("unfold3_rule",
        "unfold (VE,{| idvalseq |}, {| idvalseq' |} ) ==> \
       \  unfold (VE, {| (f, closure (match,E,VE')), idvalseq |}, \
       \             {| (f, closure (match,E,VE)), idvalseq' |}) ")];


val record_lookup_spec = 
    [("record_lookup1_rule", 	
         " record_lookup (lab, {lab = v} inVal, v)"),
     ("record_lookup2_rule", 	
         " record_lookup (lab, {lab = v, valrow} inVal, v)"),
     ("record_lookup3_rule", 	
         " record_lookup (lab, {valrow} inVal, v) ==> \
        \  record_lookup (lab, {lab' = w, valrow} inVal, v)") ];

val VE0_spec =
    [ ("VE0",
        "VE0 = {| (var plus, val plus),                    \
     \            (var minus, val minus),                  \
     \            (var times, val times),                  \
     \            (var less, val less),                    \
     \            (var zero, val zero),                    \
     \            (var not, val not),                      \
     \            (var head, val head),                    \
     \            (var tail, val tail),                    \
     \            (var null, val null) |}")];                    

val arith_spec =
    [("minus1",    "m #- m == 0"),
     ("minus2",	   "m  #- 0 == m"),
     ("minus3",	   "(suc m)  #- (suc n) == m  #- n"),
     ("mult1",	   "m  #* (suc 0) == m"),
     ("mult2",	   "(suc 0)  #* m == m")];

val apply_spec =
    [("plus_rule",
        "v = num m  #+ n ==> apply <val plus, (-num m, num n-), v>"),
     ("minus_rule",
        "v = num m  #- n ==> apply <val minus, (-num m, num n-), v>"),
     ("times_rule",
        "v = num m  #* n ==> apply <val times, (-num m, num n-), v>"),
     ("less_rule",
        "v = tr (m #< n) ==> apply <val less, (-num m, num n-), v>"),
     ("zero1_rule",
        "v = <con true> ==> apply <val zero, num 0,  v> "),
     ("zero2_rule",
        "v = <con false> ==> apply <val zero, num suc n,  v> "),
     ("not1_rule",
        "v = <con false> ==> apply <val not, <con true>,  v> "),
     ("not2_rule",
        "v = <con true> ==> apply <val not, <con false>,  v> "),
     ("head_rule",
        "apply <val head, v cons L, v>"),
     ("tail_rule",
        "apply <val tail, v cons L, L>"),
     ("null1_rule",
        "v = <con false> ==> apply <val null, w cons L, v>"),
     ("null2_rule",
        "v = <con true> ==> apply <val null, [], v>"),
     ("cons_rule",
        "apply <<con cons>, (-v, L-), v cons L>")]; 

  
val objects_spec = 
            iff_subst_spec @ 
            congs_spec @
            lookup_spec @
	    delete_spec @
	    combine_spec @
	    Combine_spec @
	    unfold_spec @ 
            record_lookup_spec @
            VE0_spec @
            arith_spec @ 
            apply_spec;

val thy = extend_theory Obj.thy "OBJRULE"
     ([], [], [], [], [], None)  objects_spec;   

val sign = sign_of thy;

end;
end;
