(* -------------------------------------------------------------*)
(*								*)
(*		Mrule.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature MRULE =
  sig
   structure Match: MATCH
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor MruleFun 
 (structure Match : MATCH) : MRULE =  
struct
structure Match = Match;
local open Syntax 
in

val spec =
    [("Mrule",					(* Rules 127, 128  *)
        "((EX VE E'' v''. E, v ||- pat ~> VE  in1VarEnv'  [Pat] & \
        \  Combine (E, <{| |}, VE, {| |}>, E'') &  \
        \   E'' |- exp ~> v') |   \               
        \ (E, v ||- pat ~> FAIL in2VarEnv' [Pat] & v' = FAIL in2Val'))      \ 
        \ <-> E,v |- pat => exp ~> v' [Match]")];


val thy = extend_theory Match.thy "MRULE"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
