(* -------------------------------------------------------------*)
(*								*)
(*		Match.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature MATCH =
  sig
   structure Exp: EXP
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor MatchFun 
 (structure Exp : EXP) : MATCH =  
struct
structure Exp = Exp;
local open Syntax 
in

val spec =
    [("Match",					(* Rules 124,126  *)
        "((EX v''. E, v |- pat => exp ~> v' [Match] & v' = v'' in1Val') | \
        \ (EX v''. E, v |- pat => exp ~> FAIL in2Val' [Match] &   \
        \  E, v |- match ~> v' [Match] & v' = v'' in1Val') | \
        \ (E, v |- pat => exp ~> v' [Match] &   \
        \  E, v |- match ~> v' [Match] & v' = FAIL in2Val')) <-> \
         \ E, v |- pat => exp | match ~> v' [Match]")];


val thy = extend_theory Exp.thy "MATCH"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
