(* -------------------------------------------------------------*)
(*								*)
(*		ExpRow.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature EXPROW =
  sig
   structure AtExp: ATEXP
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor ExpRowFun 
 (structure AtExp : ATEXP) : EXPROW =  
struct
structure AtExp = AtExp;
local open Syntax 
in

val spec =
    [("ExpRow1",					(* Rule 110a *)
	  "E |- exp ~> v in1Val' <-> \
	  \ E |- lab = exp ~> lab = v in1ValRow' [ExpRow]"),
     ("ExpRow2",					(* Rule 110b *)
	  "(E |- exp ~> v in1Val' & \
	  \ E |- exprow ~> valrow in1ValRow' [ExpRow]) <-> \
          \ E |- lab = exp, exprow  ~> lab = v, valrow in1ValRow' [ExpRow]")];


val thy = extend_theory AtExp.thy "EXPROW"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
