(* -------------------------------------------------------------*)
(*								*)
(*			Dec.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature DEC =
  sig
   structure Mrule: MRULE
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor DecFun 
 (structure Mrule : MRULE) : DEC =  
struct
structure Mrule = Mrule;
local open Syntax 
in

val spec =
    [("Val",					(* Rule 129 *)
	"E ||- valbind ~> VE in1VarEnv' [ValBind] <-> \		
       \ E ||- val valbind ~> <{| |}, VE, {| |}> in1Env'"),
     ("Exception",				(* Rule 130 *)
	"E ||- exbind ~> EE in1VarEnv' [ExBind] <-> \		
       \ E ||- exception exbind ~> <{| |}, {| |}, EE> in1Env'"),
     ("Local",					(* Rule 131 *)
	" (EX E1 E'. E ||- dec1 ~> E1 in1Env' & Combine (E, E1, E') & \
	\   E' ||- dec2 ~> E2)  <-> \
	\   E ||- local dec1 in dec2 end ~> E2"),
						 (* Rule 132 omitted *)
     ("Nothing",					(* Rule 133 *)
	"E' = <{| |}, {| |}, {| |}> in1Env' <-> E ||- nothing ~> E'"),
     ("Comp1",					(* Rule 134a *)
	"(EX E1 E' E2. E ||- dec1 ~> E1 in1Env' & Combine (E,E1,E') & \
	\   E' ||- dec2 ~> E2 in1Env' & Combine (E1,E2,E3)) <-> \
	\   E ||- dec1  dec2 ~> E3 in1Env'"),
     ("Comp2",					(* Rule 134b *)
	"(EX E1 E' E2. E ||- dec1 ~> E1 in1Env' & Combine (E,E1,E') & \
	\   E' ||- dec2 ~> E2 in1Env' & Combine (E1,E2,E3) ) <-> \
	\   E ||- dec1 ; dec2 ~> E3 in1Env'")];


val thy = extend_theory Mrule.thy "DEC"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
