(* -------------------------------------------------------------*)
(*		DRule.ml: 					*)
(*		Derived Inference Rules				*)
(* ------------------------------------------------------------ *)


signature DRULE =
  sig
  structure ObjRule : OBJRULE
  structure Merge : MERGE
  structure Tools : TOOLS
  val iff_subst :thm list 
  val congs : thm list 
  val lookup : thm list 
  val delete : thm list
  val combine : thm list
  val Combine : thm list
  val unfold : thm list 
  val record_lookup : thm list
  val VE0 : thm list
  val arith : thm list
  val apply : thm list
  val drules : {def:thm,elim:thm,intr:thm list,name:string} list 
  val Apply_Con : thm
  val Apply_Basval : thm
  val Apply_Match : thm
  val sh : string -> unit
  val intr : string -> thm list
  val elim :  string -> thm 
  val def :  string -> thm 
  val thy : theory
end;

functor DRuleFun 
 (structure Merge : MERGE and 
            ObjRule : OBJRULE and
            AtExp : ATEXP and
            ExpRow : EXPROW and
            Exp : EXP and
            Match : MATCH and
            Mrule : MRULE and
            Dec : DEC and
            ValBind : VALBIND and
            AtPat : ATPAT and
            PatRow : PATROW and
            Program : PROGRAM and 
            Tools : TOOLS)  : DRULE =  
struct
structure ObjRule = ObjRule
structure Merge = Merge
structure Tools = Tools
local open  ObjRule Merge Syntax Tools
in


(* -------------------------------------------------------------*)
(*		Derived Rules 					*)
(* ------------------------------------------------------------ *)

val iff_subst = extract thy iff_subst_spec;
val congs = extract thy congs_spec;
val lookup = extract thy lookup_spec;
val combine = extract thy combine_spec;
val Combine = extract thy Combine_spec;
val delete = extract thy delete_spec;
val unfold = extract thy unfold_spec;
val record_lookup = extract thy record_lookup_spec;
val VE0 = extract thy VE0_spec;
val arith = extract thy arith_spec;
val apply = extract thy apply_spec;

val elaboration_spec =
	    AtExp.spec @
            ExpRow.spec @
            Exp.spec @
            Match.spec @
            Mrule.spec @
            Dec.spec @
            ValBind.spec @
            AtPat.spec @
            PatRow.spec @
            Program.spec;

val drules = map (mk_drules thy) (map fst elaboration_spec); 

val sh = show drules;

fun intr s = map strip_equal (get_intr drules s);  (* Temporary fix *)

val elim = get_elim drules;

val def = get_def drules;

val thy = thy;

(* -------------------------------------------------------------*)
(*		Special Rules 					*)
(* ------------------------------------------------------------ *)

val [Apply_Con, Apply_ExName, Apply_Basval, Apply_Match] = intr "Apply";

end;
end;
