(* -------------------------------------------------------------*)
(*								*)
(*		AtPat.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature ATPAT =
  sig
   structure ValBind: VALBIND
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor AtPatFun 
 (structure ValBind : VALBIND) : ATPAT =  
struct
structure ValBind = ValBind;
local open Syntax 
in

val spec =
    [("Wild_Pat",					(* Rule 140  *)
         "VE' = {| |}  in1VarEnv' <-> E, v ||- _ ~> VE'  [Pat]"),
     ("Scon_Pat",					(* -- Rules 141,142  *)
         "((v = num n & VE' = {| |} in1VarEnv') | \
         \ (VE' = FAIL in2VarEnv')) <-> \ 
         \  E, v ||- scon n ~>  VE' [Pat]"),
     ("Var_Pat",					(* Rule 143  *)
         "VE' = {| (var x,v) |}  in1VarEnv' \
	 \  <-> E, v ||- var x ~> VE'  [Pat]"),
     ("Con_Pat",					(* -- Rules 144,145  *)
       "((v = <con c> & VE' = {| |}  in1VarEnv') | \
       \ (VE' = FAIL in2VarEnv')) <-> \ 
       \  E, v ||- con c ~> VE' [Pat]"), 
     ("ExCon_Pat",					(* -- Rules 146,147  *)
       "((EX SE VE EE. lookup (excon e, VE, <exname en>) & \
       \  VE' = {| |}  in1VarEnv' & E = <SE,VE,EE>) | \
       \ (VE' = FAIL in2VarEnv')) <-> \ 
       \  E, <exname en> ||- excon e ~> VE' [Pat]"), 
     ("Empty_Record_Pat",				(* Rule 148a *)
         "VE' = {| |}  in1VarEnv' <-> E, {} inVal ||- {} ~> VE' [Pat]"),
     ("Record_Pat",				(* -- Rule 148 *)
         "((EX VE. E, r ||- patrow ~> VE' [PatRow] & VE' = VE  in1VarEnv') | \
        \  (E, r ||- patrow ~>  VE' [PatRow] & VE' = FAIL in2VarEnv')) \
        \  <-> E, r ||- {patrow} ~> VE' [Pat]"), 
     ("Bracket_Pat",					(* -- Rule 149a *)
	 "((EX VE. E, v ||- pat ~> VE' [Pat] & VE' = VE in1VarEnv') |  \
	\  (EX VE. E, v ||- pat ~> VE' [Pat] & VE' = FAIL in2VarEnv')) \
        \ <-> E, v ||- (- pat -) ~> VE' [Pat]")];


val thy = extend_theory ValBind.thy "ATPAT"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
