(* -------------------------------------------------------------*)
(*								*)
(*		AtExp.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature ATEXP =
  sig
   structure Obj: OBJ
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor AtExpFun 
 (structure Obj : OBJ) : ATEXP =  
struct
structure Obj = Obj;
local open Syntax 
in

val spec =
   [ ("Scon",					(* Rule 103  *)
	  "v = num n <-> E |- scon n ~> v in1Val'"), 
     ("Var",					(* Rule 104 *)
	  "(EX SE VE EE. lookup (var x,VE,v) & E = <SE, VE, EE> ) \
        \   <-> E |-  var x ~> v in1Val'  "),  
     ("Con",					(* Rule 105 *)
	  "v = <con c> <-> E |- con  c ~> v in1Val' "),
     ("ExCon",					(* Rule 106 *)
	  "(EX SE VE EE. lookup (excon e,VE, <exname en>) & \
        \     E = <SE, VE, EE> ) \
         \   <-> E |-  excon e ~> <exname en> in1Val'  "),  
     ("Empty_Record",				(* Rule 107a *)
	  " v = {} inVal <-> E |- {} ~> v in1Val'"),
     ("Record",					(* Rule 107b *)
	  "(EX valrow. E |- exprow ~> valrow in1ValRow' [ExpRow] & \
         \ v = {valrow} inVal) <->  E |- {exprow} ~> v in1Val'  "),
     ("Let",					(* Rule 108  *)
        "(EX E' E''. E ||- dec ~> E' in1Env' & Combine (E,E',E'') & \
          \ E'' |- exp ~> v) <-> \
          \ E |- let dec in exp end ~> v"),
     ("Bracket",				(* Rule 109 *)
	"E |- exp ~> v <-> E |- (- exp -) ~> v ")];


val thy = extend_theory Obj.thy "ATEXP"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
