(* -------------------------------------------------------------*)
(*								*)
(*		ValBind.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature VALBIND =
  sig
   structure Dec: DEC
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor ValBindFun 
 (structure Dec : DEC) : VALBIND =  
struct
structure Dec = Dec;
local open Syntax 
in

val spec =
    [("ValBind1",				(* Rule 26a *)
         "(EX t. C ||- pat ~~> (VE, t) [Pat] & C |- exp ~~> t) <-> \
        \    C ||- pat = exp ~~> VE [ValBind]"),
     ("ValBind2",				(* Rule 26b *)
         "(EX VE VE' t. C ||- pat ~~> (VE, t) [Pat] & C |- exp ~~> t & \
        \    C ||- valbind ~~> VE' [ValBind] & VE_combine (VE,VE',VE'')) <-> \
        \    C ||- pat = exp and valbind ~~> VE'' [ValBind] "),
     ("Rec",					(* Rule 27 *)
        "(EX C'. COMBINE (C,<{| |}, {| |}, <{| |}, {| |}, VE, {| |}>>,C') & \
	\ C' ||- valbind ~~> VE [ValBind]) <-> \
        \   C ||-  rec valbind ~~> VE [ValBind]") ];


val thy = extend_theory Dec.thy "VALBIND"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
