(* -------------------------------------------------------------*)
(*								*)
(*		TypBind.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature TYPBIND =
  sig
   structure ValBind: VALBIND
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor TypBindFun 
 (structure ValBind : VALBIND) : TYPBIND =  
struct
structure ValBind = ValBind;
local open Syntax 
in

val spec =
    [("TypBind1",				(* Rule 28a *)
         "(EX t. C |- ty ~~> t [Ty] & \
        \  TE = {| (tycon, (lam tyvarseq.t, {| |})) |} ) <-> \
        \    C ||- tyvarseq tycon is ty ~~>  TE [TypBind]"),
     ("TypBind2",				(* Rule 28b *)
         "(EX t tycontystrseq. C |- ty ~~> t [Ty] & \
        \  C ||- typbind ~~> {| tycontystrseq |} [TypBind] & \
        \  TE' = {| (tycon, (lam tyvarseq.t, {| |})), tycontystrseq |}) <-> \
        \    C ||- tyvarseq tycon is ty and typbind ~~> TE' [TypBind]")];


val thy = extend_theory ValBind.thy "TYPBIND"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
