(* -------------------------------------------------------------*)
(*								*)
(*		TySeq.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature TYSEQ =
  sig
   structure TyRow: TYROW
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor TySeqFun 
 (structure TyRow : TYROW) : TYSEQ =  
struct
structure TyRow = TyRow;
local open Syntax 
in

val spec =
    [("TySeq_Empty",						
	  "typeseq = typeempty <->  C |-  tyempty ~~> typeseq [TySeq]"),
     ("TySeq",				
	  "(C |- ty ~~> t [Ty] & C |- tyseq ~~> typeseq [TySeq])  \
        \   <-> C |- ty tycons tyseq ~~> t typecons typeseq [TySeq]")];

val thy = extend_theory TyRow.thy "TYSEQ"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
