(* -------------------------------------------------------------*)
(*								*)
(*		TyRow.ml:					*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature TYROW =
  sig
   structure Ty: TY
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor TyRowFun 
 (structure Ty : TY) : TYROW =  
struct
structure Ty = Ty;
local open Syntax 
in

val spec =
    [("TyRow1",						(* Rule 52a *)
	  "C |- ty ~~> t [Ty] <-> C |- lab = ty ~~> lab = t [TyRow]"),
     ("TyRow2",				(* Rule 52b *)
	  "(C |- ty ~~> t [Ty] & C |- tyrow ~~> typerow [TyRow]) <-> \
          \ C |- lab = ty, tyrow  ~~> lab = t, typerow  [TyRow]")];


val thy = extend_theory Ty.thy "TYROW"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
