(* -------------------------------------------------------------*)
(*								*)
(*			Ty.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature TY =
  sig
   structure PatRow: PATROW
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor TyFun 
 (structure PatRow : PATROW) : TY =  
struct
structure PatRow = PatRow;
local open Syntax 
in

val spec =
   [("TyVar_Ty",					(* Rule 47 *)
        "a = b <-> C |- 'a ~~> 'b [Ty]"),
    ("Empty_Record_Ty",				(* Rule 48a *)
        "t =  {} inType <-> C |- {} ~~> t [Ty]"),
    ("Record_Ty",				(* Rule 48b *)
         "C |- tyrow ~~> typerow [TyRow]  \
        \  <-> C |- {tyrow} ~~> {typerow} inType [Ty]"),
    ("TyCon",					(* Rule 49 *)
	  "(EX SE EE TE VE theta CE. lookup_tycon (tycon, TE, (theta, CE)) & \
        \     C = <{| |}, {| |}, <SE, TE, VE, EE>> & \
        \         theta = lam tyvarseq.t \
        \     & C |- tyseq ~~> typeseq [TySeq] & \
        \      subst_seq (t, typeseq, tyvarseq, t')) \
        \  <-> C |- tyseq tycon ~~> t' [Ty]"), 
    ("Fn_Ty",					(* Rule 50 *)
         "(C |- ty ~~> t [Ty] & C |- ty' ~~> t' [Ty])  \
        \  <-> C |- ty -> ty' ~~> t ->> t' [Ty]"),
    ("Bracket_Ty",				(* Rule 51 *)
         "C |- ty ~~> t [Ty] <-> C |- (-ty-) ~~> t [Ty]")];


val thy = extend_theory PatRow.thy "TY"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
