(* -------------------------------------------------------------------- *)
(*									*)
(*		Test6.ml						*)
(*									*)
(* -------------------------------------------------------------------- *)

print "\n\n Test5.ml\n\n";
print "\n\n Type Declarations\n\n";


(* -------------------------------------------------------------------- *)
(*	Type Declarations						*)
(* -------------------------------------------------------------------- *)


dec_elab C "type <> fred is Int";

dec_elab C "type <> fred is Bool";

dec_elab C "type <> fred is Bool; val var x = con true : <> fred";

dec_elab C "type <> fred is Bool; type <> jack is <> fred";  

dec_elab C "type <> fred is Bool -> Bool";

dec_elab C "type <> fred is <Int> List";

dec_elab C "type <'a> fred is <'a> List";

dec_elab C "type <'a, 'b> fun is 'a -> 'b";

dec_elab C "type <'a, 'b> pair is 'a * 'b";

(* -------------------------------------------------------------------- *)
(*	Datatype Declarations						*)
(* -------------------------------------------------------------------- *)

dec_elab C "datatype <> colour =  con red";

dec_elab C "datatype <> colour = con red | con white";

dec_elab C "datatype <> colour =  con red of Int | con white | con blue";

dec_elab C "datatype <> Natural =  con Zero | con Succ of <> Natural";

dec_elab C "datatype <'a> Mylist =  con MyNil | con MyCons of 'a * <'a> Mylist";

dec_elab C "datatype <> colour =  con red; val var result = con red";

dec_elab C "datatype <> colour = con red | con white;   \
            \ val var is_red = fn con red => con true | _ => con false;  \
            \ val var result = var is_red ` con red";

dec_elab C "datatype <> btree =  con EMPTY | con leaf | \
          \ con node of <> btree * <> btree"; 

(* -------------------------------------------------------------------- *)
(*	Abstype Declarations						*)
(* -------------------------------------------------------------------- *)

dec_elab C "abstype <'a> set =  con SET of <'a> List  \
         \ with val var empty = con SET ` [];      \
         \      val var singleton = fn var e => (- con SET ` [var e] -) \
         \ end";

dec_elab C "abstype <'a> set =  con SET of <'a> List  \
         \ with val var empty = con SET ` [];      \
         \      val var singleton = fn var e => (- con SET ` [var e] -) \
         \ end; \
         \ val var result = [var singleton ` var x]";



