

(* -------------------------------------------------------------------- *)
(*									*)
(*		Test4.ml						*)	
(*									*)
(* -------------------------------------------------------------------- *)

print "\n\n Test4.ml\n\n";
print "\n\n Functions\n\n";


(* -------------------------------------------------------------------- *)
(* 	Functions							*)
(* -------------------------------------------------------------------- *)

dec_elab C "val var Id = (- fn var x => var x -)";

exp_elab C "let val var Id = (- fn var x => var x -) in var Id end";

exp_elab C "let val var Id = (- fn var x => var x -) in \
     \ (- var Id `(- var Id -)-) end";

dec_elab C "val var Makepair = \
    \ (- fn var x => (- let val var z = var x in (- fn var y => \
    \  (- var z, var y -) -) end -)-)";

exp_elab C "(- fn var x => var x -)`(- scon n -)";

exp_elab C "(- fn var z => var y -)`(- var y -)"; 
 
dec_elab C "val var f = (- fn var x => (- fn var y => (- var x,var y -) -) -)";
 
exp_elab C "let val var f = (- fn var x => (- fn var y => \
   \  (- var x, var y -) -) -) in (- var f` (- scon n -)-)`(- var x -) end";

(* -------------------------------------------------------------------- *)
(* 	Pattern Matching						*)
(* -------------------------------------------------------------------- *)

exp_elab C "let val var fst = \
\ (- fn (- var x, scon k -) => var x | _  => scon s -) \
     \  in var fst ` (- scon r, scon k -) end";

exp_elab C "let val var fst = \
\  (- fn (- var x, scon k -) => var x | _  => scon 0 -) \
     \  in var fst ` (- scon r, scon p -) end";

(* -------------------------------------------------------------------- *)
(* 	 This is a famous nasty LISP example  				*)
(* 	- p311 in Winston & Horn					*)
(*	Note that x appears as both a bound and a free variable!	*)
(* -------------------------------------------------------------------- *)

exp_elab C "let val var twice = (- fn var f => (- fn var x => \
  \ (- var f` (- var f ` (- var x -)-)-)-)-); \
  \       val var timesx = (- fn var q => (-var q * var x-)-) in \
  \      (-var twice ` (- var timesx -)-)` (- scon n -) end";

