(* -------------------------------------------------------------------- *)
(*									*)
(*		Example proofs of programs in FUNC 			*)
(*		This is the main test file				*)
(*									*)
(* -------------------------------------------------------------------- *)

System.Control.primaryPrompt := "ELLE > ";
System.Control.secondaryPrompt := "more.. >";

print "\n\n Elaboration: Verification of Example Programs \n\n";

Pretty.setmargin 120;
goals_limit := 10;
print_depth 0;

open System.Timer;
open Elab;
open Prover;

(* simplify the printing of syntax, types and closures *)

SML_Syntax.show_full_syntax := false;
Obj.show_full_types := false;
Obj.show_closures := false;


val start = start_timer();


(* start with a very simple context, and display it fully during proofs *)


val C = "<{| |}, {| |}, <{| |},                     \      
           \  {| |},                                \                
           \  {|  (var x : int),                    \
           \      (var y : bool),                   \
           \      (var z : int) |},                 \  
           \  {| |}>>";                                                            

Obj.show_contexts := true;
Obj.show_envs := true;

use "Test1.ml";


(* the remaining test files use a much larger initial context, including a
   non-empty type environment.  This context is not displayed during proofs *)


val C = "<{| |}, {| |}, <{| |},                                                 \      
           \   {| (UNIT, (lam <>. {} inType, {| |})),                           \       
           \      (BOOL, (lam <>. bool,                                         \
           \          {| (con true : bool), (con false : bool) |})),            \
           \      (INT, (lam <>. int, {| |})),                                  \
           \      (List, (lam <'a>.<'a> list,                                   \
           \          {| (con nil :  close (<'a> list, {| |})),                 \
           \             (con cons :  close ((-'a * (-<'a> list-)-) ->>         \
           \                     (-<'a> list-),  {| |}) ) |})),                 \
           \      (EXN, (lam <>. exn, {| |})) |},                               \                
           \  {|  (var x : int),                                                \
           \      (var y : bool),                                               \
           \      (var z : int),                                                \
           \      (var L : <int> list),                                         \
           \      (var plus :  int  * int  ->> int ),                           \    
           \      (var minus : int  * int  ->> int),                            \
           \      (var times : int  * int  ->> int),                            \
           \      (var zero : int  ->> bool),                                   \
           \      (var not : bool  ->> bool),                                   \
           \      (var head : close (<'a> list ->> 'a, {| |})),                 \
           \      (var tail : close  ((-<'a> list-) ->> (-<'a> list-), {| |})), \
           \      (var null : close (<'a> list ->> bool, {| |})),               \
           \      (con true : bool),                                            \
           \      (con false : bool),                                           \
           \      (con nil : close (<'a> list, {| |})),                         \
           \      (con cons :                                                   \
           \             close ((-'a * (-<'a> list-)-) ->>                      \
           \                        (-<'a> list-),  {| |})) |},                 \  
           \  {| |}>>";                                                            

map use ["Test2.ml", "Test3.ml", "Test4.ml",
         "Test5.ml", "Test6.ml", "Test7.ml"];

val non_gc_time = check_timer start;
val gc_time = check_timer_gc start;
val total_time = add_time (non_gc_time, gc_time);
print_depth 10;
print ("\n\n\nAll examples successfully \ 
      \ verified in : " ^(makestring total_time)^" seconds\n\n\n\n");

