(* ------------------------------------------------------------ *)
(*								*)
(*	 ROOT.ml:  root file for elaboration			*)
(*	 							*)
(* ------------------------------------------------------------ *)

writeln "Root File for Functional Language Verifier";

print_depth 1; 
  
use "Obj.ml"; 

use "ObjRule.ml"; 

use "AtExp.ml";
use "ExpRow.ml";
use "Exp.ml";
use "Match.ml";
use "Mrule.ml";
use "Dec.ml";
use "ValBind.ml";
use "TypBind.ml";
use "DatBind.ml";  
use "ConBind.ml";  
use "ExBind.ml";  
use "AtPat.ml";
use "PatRow.ml";
use "Pat.ml";
use "Ty.ml";
use "TyRow.ml";
use "TySeq.ml";
use "Program.ml";

use "Merge.ml"; 

use "DRule.ml"; 
use "Prover.ml";


structure Obj =  ObjFun (SML_Syntax);

structure ObjRule = ObjRuleFun 
     (structure Obj = Obj and SML_Syntax=SML_Syntax);

structure AtExp   = AtExpFun (structure Obj =  Obj); 
structure ExpRow  = ExpRowFun (structure AtExp =  AtExp);
structure Exp     = ExpFun (structure ExpRow =  ExpRow);
structure Match   = MatchFun (structure Exp =  Exp);
structure Mrule   = MruleFun (structure Match =  Match);
structure Dec     = DecFun (structure Mrule =  Mrule);
structure ValBind = ValBindFun (structure Dec =  Dec);
structure TypBind = TypBindFun (structure ValBind =  ValBind);
structure DatBind = DatBindFun (structure TypBind =  TypBind);
structure ConBind = ConBindFun (structure DatBind =  DatBind);
structure ExBind  = ExBindFun (structure ConBind =  ConBind);
structure AtPat   = AtPatFun (structure ExBind =  ExBind);
structure PatRow  = PatRowFun (structure AtPat =  AtPat);
structure Pat     = PatFun (structure PatRow =  PatRow);
structure Ty      = TyFun (structure PatRow =  PatRow);
structure TyRow   = TyRowFun (structure Ty =  Ty);
structure TySeq   = TySeqFun (structure TyRow =  TyRow);
structure Program = ProgramFun (structure TySeq =  TySeq);

structure Merge = MergeFun 
  (structure ObjRule = ObjRule and Program =  Program);

structure DRule = DRuleFun 
  (structure Merge = Merge and
            ObjRule  = ObjRule and
            AtExp =  AtExp and
            ExpRow =  ExpRow and
            Exp =  Exp and
            Match =  Match and
            Mrule =  Mrule and
            Dec =  Dec and
            ValBind =  ValBind and
            TypBind =  TypBind and
            DatBind =  DatBind and
            ConBind =  ConBind and
            ExBind =  ExBind and
            AtPat =  AtPat and
            PatRow = PatRow  and
            Ty = Ty  and
            TyRow =  TyRow and
            TySeq = TySeq  and
            Program =  Program and 
            Tools = Tools);

structure Prover = ProverFun
      (structure DRule=DRule);

structure Elab =
struct
   structure Obj =  Obj
   structure ObjRule =  ObjRule
   structure AtExp =  AtExp
   structure ExpRow  = ExpRow
   structure Exp     = Exp
   structure Match   = Match
   structure Mrule   = Mrule
   structure Dec     = Dec
   structure ValBind = ValBind
   structure TypBind = TypBind
   structure DatBind = DatBind
   structure ConBind = ConBind
   structure ExBind  = ExBind
   structure AtPat   = AtPat
   structure PatRow  = PatRow
   structure Pat     = Pat
   structure Ty      = Ty
   structure TyRow   = TyRow
   structure TySeq   = TySeq
   structure Program = Program
   structure Merge = Merge
   structure DRule = DRule
   structure Prover = Prover
end;

(*  (exportML "ELAB"; print "Elaboration\n");  *)





