(* -------------------------------------------------------------*)
(*								*)
(*		Program.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature PROGRAM =
  sig
   structure TySeq: TYSEQ
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor ProgramFun 
 (structure TySeq : TYSEQ) : PROGRAM =  
struct
structure TySeq = TySeq;
local open Syntax 
in

val spec =
    [("Program1", 					(* Rule 196a *)
	"(EX E. C ||- dec ~~> E & COMBINE (C,<{| |}, {| |}, E>,C')) <-> \
      \     C ||- dec ; ~~> C' [Program] "),
     ("Program2", 					(* Rule 196b *)
	"(EX E. C ||- dec ~~> E & COMBINE (C,<{| |}, {| |}, E>,C') & \
	\   C' ||- program ~~> C' [Program])<->  \
	\   C ||- dec ; program ~~> C' [Program]")];


val thy = extend_theory TySeq.thy "PROGRAM"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
