(* -------------------------------------------------------------*)
(*								*)
(*		PatRow.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature PATROW =
  sig
   structure AtPat: ATPAT
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor PatRowFun 
 (structure AtPat : ATPAT) : PATROW =  
struct
structure AtPat = AtPat;
local open Syntax 
in

val spec =
    [("Wild_PatRow",				(* Rule 40 *)
        "VE = {| |} <-> C ||- ... ~~> (VE, rectype) [PatRow]"),
     ("PatRow1",				(* Rule 41a *)
        "(EX t. C ||- pat ~~> (VE,t) [Pat] & t' = {lab = t} inType) <-> \
	\ C ||- lab = pat ~~> (VE, t') [PatRow] "),
     ("PatRow2",				(* Rule 41b *)
        "(EX VE VE' t. C ||- pat ~~> (VE,t) [Pat] & \
	\ C ||- patrow ~~> (VE', {typerow} inType) [PatRow] & \
	\  VE_combine (VE,VE',VE'') & t' =  {lab = t, typerow} inType) <-> \
	\ C ||- lab = pat, patrow ~~> (VE'', t') [PatRow]")];


val thy = extend_theory AtPat.thy "PATROW"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
