(* -------------------------------------------------------------*)
(*								*)
(*		Pat.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature PAT =
  sig
   structure PatRow: PATROW
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor PatFun 
 (structure PatRow : PATROW) : PAT =  
struct
structure PatRow = PatRow;
local open Syntax 
in

val spec =					(* Rule 42 not needed *)
  [("Con_Val_Pat",				(* Rule 43 *)
       " (EX SE TE VE EE s t'. C = <{| |}, {| |}, <SE, TE, VE, EE>> & \
      \  lookup (con c, VE, s) & s > t' ->> t &  \
      \  C ||- pat ~~> (VE', t') [Pat] ) <-> \
      \  C ||- con c ` pat ~~> (VE', t) [Pat]"),
   ("ExCon_Val_Pat",				(* Rule 44 *)
       " (EX SE TE VE EE s t'. C = <{| |}, {| |}, <SE, TE, VE, EE>> & \
      \  lookup (excon e, VE, s) & s > t ->> exn &  \
      \  C ||- pat ~~> (VE', t) [Pat] ) <-> \
      \  C ||- excon e ` pat ~~> (VE', exn) [Pat]"),
   ("Typed_Pat",				(* Rule 45 *)
       "(C ||- pat ~~> (VE, t) [Pat] & C |- ty ~~> t [Ty]) <-> \
      \  C ||- pat : ty ~~> (VE, t) [Pat]"),
   ("Layered_Pat",				(* Rule 46a *)	
       "(C ||- var x ~~> (VE, t) [Pat] & \
      \  C ||- pat ~~> (VE', t) [Pat] & VE_combine (VE, VE', VE'')) <-> \
      \  C ||- var x as pat ~~> (VE'', t) [Pat]"),
    ("Typed_Layered_Pat",			(* Rule 46b *)
       "(C ||- var x ~~> (VE, t) [Pat] &  C |- ty ~~> t [Ty] & \
      \  C ||- pat ~~> (VE', t) [Pat] & VE_combine (VE, VE', VE'')) <-> \
      \  C ||- var x : ty as pat ~~> (VE'', t) [Pat]")];

val thy = extend_theory PatRow.thy "PAT"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
