(* -------------------------------------------------------------*)
(*		ObjRule.ml:					*)
(*	 Inference Rules for Semantic Objects			*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature OBJRULE =
  sig
   structure SML_Syntax : SML_SYNTAX and  Obj: OBJ
  val sign: Sign.sg
  val thy: theory
  val congs_spec : (string * string) list 
  val lookup_spec : (string * string) list 
  val lookup_tycon_spec : (string * string) list 
  val VE_delete_spec : (string * string) list
  val VE_combine_spec : (string * string) list
  val Combine_spec : (string * string) list
  val COMBINE_spec : (string * string) list
  val TE_delete_spec : (string * string) list
  val TE_combine_spec : (string * string) list
  val VE0_spec : (string * string) list
  val TE0_spec : (string * string) list
  val trivial_instance_spec : (string * string) list
  val instance_spec : (string * string) list
  val subst_spec : (string * string) list
  val subst_seq_spec : (string * string) list
  val is_free_spec : (string * string) list
  val is_not_free_spec : (string * string) list
  val is_Free_spec : (string * string) list
  val is_not_Free_spec : (string * string) list
  val is_bound_spec : (string * string) list
  val Close_spec : (string * string) list
  val As_spec : (string * string) list
  val Abs_spec : (string * string) list
  val ABS_spec : (string * string) list
end;

functor ObjRuleFun 
 (structure SML_Syntax : SML_SYNTAX and Obj : OBJ) : OBJRULE =  
struct
structure SML_Syntax = SML_Syntax;
structure Obj = Obj;
local open Syntax 
in

(* -------------------------------------------------------------*)
(*		Inference Rules for Semantic Domains		*)
(* ------------------------------------------------------------ *)

val congs_spec =
    [("lookup_cong",  "[| (id = id'); (VE = VE'); (t = t') |] ==> \
         \  lookup (id, VE, t) <-> lookup (id', VE', t')"),
     ("lookup_tycon_cong",  "[| (tycon = tycon'); (TE = TE'); (t = t') |] ==> \
         \  lookup_tycon (tycon, TE, t) <-> \
         \      lookup_tycon (tycon', TE', t')")];

val lookup_spec= 
    [("lookup1_rule", 	
         "lookup (id, {| (id : t) |}, t)"),
     ("lookup2_rule", 	
         "lookup (id, {| (id : t), idtypeseq |}, t)"),
     ("lookup3_rule", 	
         "lookup (id, {| idtypeseq |}, t) ==> \
	 \ lookup (id, {| (id' : t'), idtypeseq |}, t)") ];

val lookup_tycon_spec= 
    [("lookup_tycon1_rule", 	
         "lookup_tycon (tycon, {| (tycon , tystr) |}, tystr)"),
     ("lookup_tycon2_rule", 	
         "lookup_tycon (tycon, {| (tycon , tystr), tycontystrseq |}, tystr)"),
     ("lookup_tycon3_rule", 	
         "lookup_tycon (tycon, {| tycontystrseq |}, tystr) ==> \
      \ lookup_tycon (tycon, {| (tycon' , tystr'), tycontystrseq |}, tystr)") ];

val VE_delete_spec =
    [("VE_delete1_rule",
        "VE_delete (id, {| |}, {| |})"),
     ("VE_delete2_rule",
        "VE_delete (id, {| (id : t) |}, {| |})"),
     ("VE_delete3_rule",
        "VE_delete (id, {| (id' : t) |}, {| (id' : t) |})"),
     ("VE_delete4_rule",
        "VE_delete (id, {| idtypeseq |}, VE) ==> \
     \      VE_delete (id, {| (id : t), idtypeseq |}, VE)"),
     ("VE_delete5_rule",
        "VE_delete (id, {| idtypeseq |}, {| idtypeseq' |}) ==> \
     \      VE_delete (id, {| (id' : t), idtypeseq |}, \
     \                  {| (id': t), idtypeseq' |})")];

val TE_delete_spec =
    [("TE_delete1_rule",
        "TE_delete (tycon, {| |}, {| |})"),
     ("TE_delete2_rule",
        "TE_delete (tycon, {| (tycon , tystr) |}, {| |})"),
     ("TE_delete3_rule",
        "TE_delete (tycon, {| (tycon', tystr) |}, {| (tycon', tystr) |})"),
     ("TE_delete4_rule",
        "TE_delete (tycon, {| tycontystrseq |}, TE) ==> \
     \      TE_delete (tycon, {| (tycon , tystr), tycontystrseq |}, TE)"),
     ("TE_delete5_rule",
        "TE_delete (tycon, {| tycontystrseq |}, {| tycontystrseq' |}) ==> \
     \      TE_delete (tycon, {| (tycon' , tystr), tycontystrseq |}, \
     \                  {| (tycon', tystr), tycontystrseq' |})")];

val VE_combine_spec =
    [("VE_combine1_rule",
        "VE_combine (VE, {| |}, VE)"),
     ("VE_combine2_rule",
        "VE_combine ({| |}, VE, VE)"),
     ("VE_combine3_rule",
        "VE_combine ({| |}, {| (id : t) |}, {| (id : t) |})"),
     ("VE_combine4_rule",
        "VE_combine ({| (id : t) |}, {| |}, {| (id : t) |})"),
     ("VE_combine5_rule",
        "VE_combine ({| (id : t) |}, {| (id : t') |}, {| (id : t') |})"),
     ("VE_combine6_rule",
        "VE_combine ({| (id : t) |}, {| (id' : t') |}, \
          \ {| (id' : t'), (id : t) |})"),
     ("VE_combine7_rule",
        "VE_delete (id, {| idtypeseq |}, {| idtypeseq' |}) ==> \
      \ VE_combine ({| idtypeseq |}, {| (id : t) |}, \
          \    {| (id : t),idtypeseq' |})"),
     ("VE_combine8_rule",
        "[| VE_combine (VE, {| idtypeseq |}, VE'); \
         \ VE_combine (VE', {| (id : t) |}, VE'') |] ==> \
         \ VE_combine (VE, {| (id : t), idtypeseq |}, VE'')") ];

val TE_combine_spec =
    [("TE_combine1_rule",
        "TE_combine (TE, {| |}, TE)"),
     ("TE_combine2_rule",
        "TE_combine ({| |}, TE, TE)"),
     ("TE_combine3_rule",
        "TE_combine ({| |}, {| (tycon , tystr) |}, {| (tycon , tystr) |})"),
     ("TE_combine4_rule",
        "TE_combine ({| (tycon , tystr) |}, {| |}, {| (tycon , tystr) |})"),
     ("TE_combine5_rule",
        "TE_combine ({| (tycon ,tystr) |}, \
          \  {| (tycon , tystr') |}, {| (tycon , tystr') |})"),
     ("TE_combine6_rule",
        "TE_combine ({| (tycon , tystr) |}, {| (tycon', tystr') |},  \
          \  {| (tycon' , tystr'), (tycon , tystr) |})"),
     ("TE_combine7_rule",
        "TE_delete (tycon, {| tycontystrseq |}, {| tycontystrseq' |}) ==> \
        \ TE_combine ({| tycontystrseq |}, \
        \  {| (tycon , tystr) |}, {| (tycon , tystr), tycontystrseq' |})"),
     ("TE_combine8_rule",
        "[| TE_combine (E, {| tycontystrseq |}, E'); \
         \ TE_combine (E', {| (tycon , tystr) |}, E'') |] ==> \
         \ TE_combine (E, {| (tycon , tystr), tycontystrseq |}, E'')") ];

val Combine_spec =
   [("Combine_rule",
      "[| VE_combine (VE,VE',VE''); VE_combine (EE, EE', EE''); \
     \    TE_combine (TE, TE', TE'') |] ==> \
     \     Combine (<SE, TE, VE, EE>, \
     \       <SE, TE', VE', EE'>, <SE, TE'', VE'', EE''>)")];

val COMBINE_spec =
   [("COMBINE_rule",
      "Combine (E,E',E'') ==> \
       \ COMBINE (<{| |}, {| |}, E>, \
       \ 	  <{| |}, {| |}, E'>, \
       \ 	  <{| |}, {| |}, E''>)")];

val  VE0_spec =
    [("VE0",
       "VE0 = {| (var plus :  int  * int  ->> int ),                          \
           \     (var minus : int  * int  ->> int),                            \
           \     (var times : int  * int  ->> int),                            \
           \     (var zero : int  ->> bool),                                   \
           \     (var not : bool  ->> bool),                                   \
           \     (var head : close (<'a> list ->> 'a, {| |})),                 \
           \     (var tail : close  ((-<'a> list-) ->> (-<'a> list-), {| |})), \
           \     (var null : close (<'a> list ->> bool, {| |})),               \
           \     (con true : bool),                                            \
           \     (con false : bool),                                           \
           \     (con nil : close (<'a> list, {| |})),                         \
           \     (con cons :                                                   \
           \      close ((-'a * (-<'a> list-)-) ->>                           \
           \            (-<'a> list-),  {| |})) |}")];    


val  TE0_spec = 
    [("TE0",
        "TE0 = {| (UNIT, (lam <>. {} inType, {| |})),                  \
           \      (BOOL, (lam <>. bool,                                 \
           \          {| (con true : bool), (con false : bool) |})),     \
           \      (INT, (lam <>. int, {| |})),                          \
           \      (List, (lam <'a>.<'a> list,                           \
           \          {| (con nil :  close (<'a> list, {| |})),          \
           \             (con cons :  close ((-'a * (-<'a> list-)-) ->>  \
           \                     (-<'a> list-),  {| |}) ) |})),         \
           \      (EXN, (lam <>. exn, {| |})) |}")];                    
        

val trivial_instance_spec =
    [("instance_tyvar_rule",
        "'a > 'a"),
     ("instance_empty_record_rule",
        "{} inType > {} inType"),
     ("instance_record_rule",
        "{tyrow}  inType > {tyrow} inType"),
     ("instance_fn_rule",
        "(t1 ->> t2) > (t1 ->> t2)"),
     ("instance_constype_rule",
        "typeseq tyname > typeseq tyname"),
     ("instance_int_rule",
        "int  > int "),
     ("instance_bool_rule",
        "bool  > bool ")];

val instance_spec =
   [("instance_close_rule",
        "close (t, VE)  > t"),
     ("instance_bound_rule",
        "[| is_bound (a,s); s > t; subst (t,t',a,t'') |]  ==>  s > t'' ")];

val subst_spec =
   [("subst_tyvar1_rule",
	"subst ('a, t', 'a, t')"),
    ("subst_tyvar2_rule",
	"subst ('a, t', 'b, 'a)"),
    ("subst_empty_record_rule",
	"subst ({} inType, t', 'a, {} inType)"),
    ("subst_record1_rule",
	"subst (t, t', 'a, t'') ==> \
        \ subst ({lab = t} inType, t', 'a, {lab = t''} inType)"),
    ("subst_record2_rule",
	"[| subst (t, t', 'a, t''); \ 
        \   subst ({typerow} inType, t', 'a, {typerow'} inType) |] \
        \   ==> subst ({lab = t, typerow} inType, t', 'a, \
        \        {lab = t'', typerow'} inType)"),
    ("subst_fn_rule",
	"[| subst (t1, t', 'a, t1'); subst (t2, t', 'a, t2') |] ==> \
	\  subst (t1 ->> t2, t', 'a, t1' ->> t2')"),
    ("subst_constype_empty_rule",
	"subst (<> tyname , t', 'a, <> tyname )"),
    ("subst_constype_rule",
	"[| subst (t, t', 'a, t''); \
        \  subst (typeseq tyname, t', 'a, typeseq' tyname) |] \
        \   ==> subst ((t typecons typeseq) tyname,\
        \     t', 'a, (t'' typecons typeseq') tyname)"),
    ("subst_int_rule",
	"subst (int , t', 'a, int )"),
    ("subst_bool_rule",
	"subst (bool , t', 'a, bool )")]


val subst_seq_spec =
   [("subst_seq_empty_rule",
	"subst_seq (t, typeempty, tyvarempty, t)"),
    ("subst_seq_rule",
    "[| subst (t, t', 'a, t''); subst_seq (t'',typeseq, tyvarseq, t''') |]\
    \  ==> subst_seq (t, t' typecons typeseq, 'a tyvarcons tyvarseq, t''')")];

val is_free_spec =
   [("is_free_tyvar_rule",
        "is_free('a, 'a)"),
    ("is_free_record1_rule",
        "is_free('a, t) ==> is_free ('a, {lab = t} inType )"),
    ("is_free_record2_rule",
        "is_free('a, {typerow} inType) ==> \
        \ is_free ('a, {lab = t, typerow} inType )"),
    ("is_free_fn1_rule",
        "is_free('a, t1) ==> is_free ('a, t1 ->> t2 )"),
    ("is_free_fn2_rule",
        "is_free('a, t2) ==> is_free ('a, t1 ->> t2 )"),
    ("is_free_constype1_rule",
        "is_free('a, t) ==> is_free ('a, (t typecons typeseq) tyname)"),
    ("is_free_constype2_rule",
        "is_free('a, typeseq tyname) ==> \
           \ is_free ('a, t typecons typeseq tyname)")];


val is_not_free_spec =
   [("is_not_free_tyvar_rule",
        "~('a = 'b) ==> ~is_free('a, 'b)"),
    ("is_not_free_empty_record_rule",
        "~is_free('a, {} inType)"),
    ("is_not_free_record1_rule",
        "~is_free('a, t) ==> ~is_free ('a, {lab = t} inType)"),
    ("is_not_free_record2_rule",
        "[| ~is_free('a, t); ~is_free('a, {typerow} inType) |] ==>\
     \   ~is_free ('a, {lab = t, typerow} inType)"),
    ("is_not_free_fn_rule",
        "[| ~is_free('a, t1); ~is_free('a,t2) |] ==> \
	\ ~is_free ('a, t1 ->> t2 )"),
    ("is_not_free_constype_empty_rule",
        "~is_free ('a, <> tyname)"),
    ("is_not_free_constype_rule",
        "[| ~is_free('a, t); ~is_free ('a, typeseq tyname) |] ==> \
     \     ~is_free ('a, t typecons typeseq tyname)"),
    ("is_not_free_closure_rule",
        "is_bound ('a, close (t, VE)) ==> ~is_free ('a, close (t,VE))"),
    ("is_not_free_int_rule",
        "~is_free('a, int )"),
    ("is_not_free_bool_rule",
        "~is_free('a, bool )")];

val is_Free_spec =
   [("is_Free1_rule",
        "is_free('a,t) ==> is_Free ('a, {| (x : t) |})"),
    ("is_Free2_rule",
        "is_Free ('a, {| idtypeseq |}) ==> \
	\ is_Free ('a, {| (x : t), idtypeseq |})")];

val is_not_Free_spec =
   [("is_Free3_rule",
        "~is_Free('a,{| |})"),
    ("is_Free4_rule",
        " ~is_free('a,t) ==> ~is_Free ('a,  {| (x : t) |})"),
    ("is_Free5_rule",
        "[| ~is_free('a,t); ~ is_Free ('a, {| idtypeseq |}) |] ==> \
      \   ~is_Free ('a,  {| (x : t),idtypeseq |})")];

val is_bound_spec =
   [("is_bound1_rule",
    "[| is_free ('a, t); ~is_Free ('a, VE) |] ==> \
    \ is_bound ('a, close (t, VE))")];

val Close_spec =
   [("Close1_rule",
        "Close (<{| |}, {| |}, <SE, TE, VE, EE>>, {| |}, {| |})"),
    ("Close2_rule", 
        "Close (<{| |}, {| |}, <SE, TE, VE, EE>>, \
        \   {| (x : t) |}, {| (x : close(t, VE)) |})"), 
    ("Close3_rule", 
        "Close (<{| |}, {| |}, <SE, TE, VE, EE>>, \
        \  {| idtypeseq |}, {| idtypeseq' |}) ==> \
        \  Close (<{| |}, {| |}, <SE, TE, VE, EE>>, \
	\ {| (x : t), idtypeseq |}, {| (x : close (t, VE)), idtypeseq' |})")];


val As_spec =
   [("As1_rule",
         "<> As <>"),
    ("As2_rule",
         "<'a> As <'a>"),
    ("As3_rule",
         "tyvarseq As typeseq ==> \
      \   'a tyvarcons tyvarseq As 'a typecons typeseq")];

val Abs_spec =
   [("Abs1_rule",
         "ABS ({| |}, {| |})"),
    ("Abs2_rule",
         "tyvarseq As typeseq ==> \
      \   ABS ({| (tycon, (lam tyvarseq. typeseq tyname, CE)) |},    \
      \        {| (tycon, (lam tyvarseq. typeseq tyname, {| |}))  |})"),
    ("Abs3_rule",
         "tyvarseq As typeseq ==> \
        \ ABS ({| tycontystrseq |}, {| tycontystrseq' |}) ==> \
        \ ABS ({| (tycon,  (lam tyvarseq.       \
        \            typeseq tyname, CE)), tycontystrseq |},    \
        \      {| (tycon,  (lam tyvarseq.       \
        \            typeseq tyname, {| |})), tycontystrseq'  |})")];
 
val ABS_spec =
    [("ABS_rule",
         "[|  ABS (TE, TE'); Combine (<{| |}, TE', {| |}, {| |}>, E, E') |] \
        \   ==> ABS (TE, E, E')")];
  
val objects_spec = 
            congs_spec @
            lookup_spec  @
            lookup_tycon_spec  @
            VE_delete_spec  @
	    VE_combine_spec @
            TE_delete_spec  @
	    TE_combine_spec @
	    Combine_spec @
	    COMBINE_spec @
	    VE0_spec @
	    TE0_spec @
            trivial_instance_spec @ 
            instance_spec @ 
	    subst_spec @
	    subst_seq_spec @
	    is_free_spec @
	    is_not_free_spec  @
	    is_Free_spec @
	    is_not_Free_spec @
            is_bound_spec @
            Close_spec @
            As_spec @
            Abs_spec @
            ABS_spec;

val thy = extend_theory Obj.thy "OBJRULE"
     ([], [], [], [], [], None)  objects_spec;   

val sign = sign_of thy;

end;
end;
