(* -------------------------------------------------------------*)
(*								*)
(*		Mrule.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature MRULE =
  sig
   structure Match: MATCH
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor MruleFun 
 (structure Match : MATCH) : MRULE =  
struct
structure Match = Match;
local open Syntax 
in

val spec =
    [("Mrule",					(* Rule 16 *)
        "(EX VE C'. C ||- pat ~~> (VE, t) [Pat] & \
      \   COMBINE (C, <{| |}, {| |}, <{| |}, {| |}, VE, {| |}>>, C') & \
      \      C' |- exp ~~> t' & t'' = t ->> t') <-> \
      \      C |- pat => exp ~~> t'' [Match]")];


val thy = extend_theory Match.thy "MRULE"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
