(* -------------------------------------------------------------*)
(*								*)
(*		Match.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature MATCH =
  sig
   structure Exp: EXP
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor MatchFun 
 (structure Exp : EXP) : MATCH =  
struct
structure Exp = Exp;
local open Syntax 
in

val spec =
    [("Match",					(* Rule 15  *)
        "  (C |- pat => exp ~~> t [Match] &  \
       \    C |- match ~~> t [Match]) <-> \
       \    C |- pat => exp | match ~~> t [Match]")];


val thy = extend_theory Exp.thy "MATCH"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
