(* -------------------------------------------------------------*)
(*								*)
(*		ExpRow.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature EXPROW =
  sig
   structure AtExp: ATEXP
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor ExpRowFun 
 (structure AtExp : ATEXP) : EXPROW =  
struct
structure AtExp = AtExp;
local open Syntax 
in

val spec =
    [("ExpRow1",				(* Rule 8a *)
	  "C |- exp ~~> t <-> C |- lab = exp ~~> lab = t [ExpRow]"),
     ("ExpRow2",				(* Rule 8b *)
	  "(C |- exp ~~> t & C |- exprow ~~> typerow [ExpRow]) <-> \
          \ C |- lab = exp, exprow  ~~> lab = t, typerow  [ExpRow]")];


val thy = extend_theory AtExp.thy "EXPROW"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
