(* -------------------------------------------------------------*)
(*								*)
(*		Exp.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature EXP =
  sig
   structure ExpRow: EXPROW
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor ExpFun 
 (structure ExpRow : EXPROW) : EXP =  
struct
structure ExpRow = ExpRow;
local open Syntax 
in

val spec =
    [					(* Rule 9 is not needed  *)
     ("Apply",					(* Rule 10 *)
        "(EX t'. C |- exp2 ~~> t' & C |- exp1 ~~> t' ->> t) <->    \
        \   C |- exp1`exp2 ~~> t"),
     ("Typed",					(* Rule 11 *)
        "(C |- exp ~~> t & C |- ty ~~> t [Ty]) <-> \
        \    C |- exp : ty ~~> t "),
     ("Handle",					(* Rule 12 *)
	"(C |- exp ~~> t & C |- match ~~> exn ->> t [Match]) \
        \   <->  C |- exp handle match ~~> t"),
     ("Raise",					(* Rule 13 *)
	"C |- exp ~~> exn <->  C |- raise exp ~~> t"),
     ("Fn",					(* Rule 14 *)
	"C |- match ~~> t [Match] <->  C |- fn match ~~> t")];


val thy = extend_theory ExpRow.thy "EXP"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
