(* -------------------------------------------------------------*)
(*								*)
(*		ExBind.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature EXBIND =
  sig
  structure ConBind: CONBIND
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor ExBindFun 
 (structure ConBind : CONBIND) : EXBIND =  
struct
structure ConBind = ConBind;
local open Syntax 
in

val spec =
    [("ExBind1",				(* Rule 31a *)
         "EE = {| (excon e : exn) |} <-> C ||- excon e ~~> EE [ExBind]"),
     ("ExBind2",				(* Rule 31b *)
         "(EX t. EE = {| (excon e : t ->> exn) |} & C |- ty ~~> t [Ty]) <-> \
       \   C ||- excon e of ty ~~> EE [ExBind]"),
     ("ExBind3",				(* Rule 31c *)
         "(EX excontypeseq. EE =  {| (excon e : exn), excontypeseq |} & \
       \   C ||- exconbind ~~> {| excontypeseq |} [ExBind]) <-> \
       \   C ||- excon e and exconbind ~~> EE [ExBind]"),
     ("ExBind4",				(* Rule 31d *)
         "(EX t excontypeseq. EE = {| (excon c : t ->> exn), excontypeseq |} & \
       \   C |- ty ~~> t [Ty] & \
       \   C ||- exconbind ~~> {| excontypeseq |} [ExBind]) <-> \
       \   C ||- excon c of ty and exconbind ~~> EE [ExBind]"),
     ("ExBind5",				(* Rule 32a *)
         "(EX SE TE VE EE. C = <{| |}, {| |}, <SE, TE, VE, EE>> & \
       \ lookup (excon e', VE, t) &  EE' = {| (excon e : t) |})\
       \     <-> C ||- excon e is e' ~~> EE' [ExBind]"),
     ("ExBind6",				(* Rule 32b *)
         "(EX SE TE VE EE. C = <{| |}, {| |}, <SE, TE, VE, EE>> & \
       \    C ||- exbind ~~> {| excontypeseq |} [ExBind] &  \
       \ lookup (excon e', VE, t) &  EE' = {| (excon e : t), excontypeseq |})\
       \     <-> C ||- excon e is e' and exbind ~~> EE' [ExBind]")];



val thy = extend_theory ConBind.thy "EXBIND"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;

