(* -------------------------------------------------------------*)
(*								*)
(*		Dec.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature DEC =
  sig
   structure Mrule: MRULE
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor DecFun 
 (structure Mrule : MRULE) : DEC =  
struct
structure Mrule = Mrule;
local open Syntax 
in

val spec =
    [("Val",					(* -- Rule 17 *)
        "(EX VE VE'. C ||-  valbind ~~> VE [ValBind] & \
	\ Close (C, VE, VE') &  C' = <{| |}, {| |}, VE', {| |}>)  \
       \ <->  C ||- val valbind ~~>  C' "),
     ("Type",					(* Rule 18 *)
        "(EX TE. C ||- typbind ~~> TE [TypBind] & \
        \ E = <{| |}, TE, {| |}, {| |}>)  <->  C ||- type typbind ~~> E"),
     ("DataType",				(* Rule 19 *)
        "(EX C' TE VE. COMBINE (C, \
        \   <{| |}, {| |}, <{| |}, TE, {| |}, {| |}>>, C') & \
        \  C' ||- datbind ~~> VE, TE [DatBind] & \
        \ E = <{| |}, TE, VE, {| |}>)  <->  C ||- datatype datbind ~~> E"),
     ("AbsType",				(* Rule 20 *)
        "(EX C' TE VE E. COMBINE (C, \
        \ <{| |}, {| |}, <{| |}, TE, {| |}, {| |}>>, C') & \
        \  C' ||- datbind ~~> VE, TE [DatBind] & \
        \  COMBINE (C, <{| |}, {| |}, <{| |}, TE, VE, {| |}>>, C'') & \
        \  C'' ||- dec ~~> E &  ABS (TE,E,E'))  \
        \    <->  C ||- abstype datbind with dec end  ~~> E'"),
     ("Exception",					(* Rule 21 *)
        "(EX excontypeseq. C ||- exbind ~~> {| excontypeseq |} [ExBind] &  \
        \ E = <{| |}, {| |}, {| excontypeseq |}, {| excontypeseq |} >)  \
        \   <->  C ||- exception exbind ~~> E"),
     ("Local",					(* Rule 22 *)
	"(EX E1 C'. C ||- dec1 ~~> E1 & \
        \  COMBINE (C, <{| |}, {| |}, E1>, C') & \
	\   C' ||- dec2 ~~> E2) <-> \
	\   C ||- local dec1 in dec2 end ~~> E2"),
						 (* Rule 23 omitted *)
     ("Nothing",				(* Rule 24 *)
	"C' = <{| |}, {| |}, {| |}, {| |}> <-> C ||- nothing ~~> C'"),
     ("Comp1",					(* Rule 25a *)
        "(EX E1 C' E2. C ||- dec1 ~~> E1 & \
	\ COMBINE (C,<{| |}, {| |}, E1>,C') &  \
        \   C' ||- dec2 ~~> E2 & Combine (E1,E2,E3)) <-> \
        \   C ||-  dec1  dec2 ~~> E3"),
     ("Comp2",					(* Rule 25b *)
        "(EX E1 C' E2. C ||- dec1 ~~> E1 & \
	\ COMBINE (C,<{| |}, {| |}, E1>,C') &  \
        \   C' ||- dec2 ~~> E2 & Combine (E1,E2,E3)) <-> \
        \   C ||-  dec1 ; dec2 ~~> E3") ];


val thy = extend_theory Mrule.thy "DEC"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
