(* -------------------------------------------------------------*)
(*								*)
(*		DatBind.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature DATBIND =
  sig
  structure TypBind: TYPBIND
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor DatBindFun 
 (structure TypBind : TYPBIND) : DATBIND =  
struct
structure TypBind = TypBind;
local open Syntax 
in

val spec =
    [("DatBind1",				(* Rule 29a *)
         "(EX CE CE' tyname. tyvarseq As typeseq &  \
        \  C, typeseq tyname ||- conbind ~~> CE [ConBind] & \
        \  Close (<{| |}, {| |}, <{| |}, {| |}, {| |}, {| |}>>, CE, CE') \
        \   & VE = CE' & TE = {| (tycon, \
	\  (lam tyvarseq. typeseq tyname, CE')) |} ) <-> \
        \    C ||- tyvarseq tycon = conbind ~~>  VE, TE [DatBind]"),
     ("DatBind2",				(* Rule 29b *)
         "(EX CE CE' tyname. tyvarseq As typeseq & \
        \  C, typeseq tyname ||- conbind ~~> CE [ConBind] & \
        \  Close (<{| |}, {| |}, <{| |}, {| |}, {| |}, {| |}>>, CE, CE') \
        \   & C ||- datbind ~~> VE, {| tycontystrseq |} [DatBind] & \
        \       VE_combine (CE', VE, VE') &  \
        \   TE' = {| (tycon, \
	\  (lam tyvarseq. typeseq tyname, CE')), tycontystrseq |} ) <-> \
        \    C ||- tyvarseq tycon = conbind and datbind \
        \          ~~> VE', TE' [DatBind]")];


val thy = extend_theory TypBind.thy "DATBIND"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
