(* -------------------------------------------------------------*)
(*		DRule.ml:	 				*)
(*		Derived Inference Rules 			*)
(* ------------------------------------------------------------ *)


signature DRULE =
  sig
  structure ObjRule : OBJRULE
  structure Merge : MERGE
  structure Tools : TOOLS
  val lookup : thm list 
  val congs : thm list 
  val lookup_tycon : thm list 
  val VE_delete : thm list
  val VE_combine : thm list
  val TE_delete : thm list
  val TE_combine : thm list
  val Combine : thm list
  val COMBINE : thm list
  val VE0 : thm list
  val TE0 : thm list
  val trivial_instance : thm list
  val instance : thm list
  val subst : thm list
  val subst_seq : thm list
  val is_free : thm list
  val is_not_free : thm list
  val is_Free : thm list
  val is_not_Free : thm list
  val is_bound :thm list
  val Close : thm list
  val As : thm list
  val Abs' : thm list
  val ABS : thm list
  val drules : {def:thm,elim:thm,intr:thm list,name:string} list 
  val sh : string -> unit
  val intr : string -> thm list
  val elim :  string -> thm 
  val def :  string -> thm 
  val thy : theory
end;

functor DRuleFun 
 (structure Merge : MERGE and 
            ObjRule : OBJRULE and
            AtExp : ATEXP and
            ExpRow : EXPROW and
            Exp : EXP and
            Match : MATCH and
            Mrule : MRULE and
            Dec : DEC and
            ValBind : VALBIND and
            TypBind : TYPBIND and
            DatBind : DATBIND and
            ConBind : CONBIND and
            ExBind : EXBIND and
            AtPat : ATPAT and
            PatRow : PATROW and
            Ty : TY and
            TyRow : TYROW and
            TySeq : TYSEQ and
            Program : PROGRAM and 
            Tools : TOOLS)  : DRULE =  
struct
structure ObjRule = ObjRule
structure Merge = Merge
structure Tools = Tools
local open  ObjRule Merge Syntax Tools
in

(* -------------------------------------------------------------*)
(*		Derived Rules 					*)
(* ------------------------------------------------------------ *)

val congs = extract thy congs_spec;
val lookup = extract thy lookup_spec;
val lookup_tycon = extract thy lookup_tycon_spec;
val VE_combine = extract thy VE_combine_spec;
val VE_delete = extract thy VE_delete_spec;
val TE_combine = extract thy TE_combine_spec;
val TE_delete = extract thy TE_delete_spec;
val Combine = extract thy Combine_spec;
val COMBINE = extract thy COMBINE_spec;
val VE0 = extract thy VE0_spec;
val TE0 = extract thy TE0_spec;
val trivial_instance = extract thy trivial_instance_spec;
val instance = extract thy instance_spec; 
val subst = extract thy  subst_spec;
val subst_seq = extract thy  subst_seq_spec;
val is_free = extract thy is_free_spec;
val is_not_free = extract thy is_not_free_spec;
val is_Free = extract thy is_Free_spec;
val is_not_Free = extract thy is_not_Free_spec;
val is_bound = extract thy is_bound_spec;
val Close = extract thy Close_spec;
val As = extract thy As_spec;
val Abs' = extract thy Abs_spec;
val ABS = extract thy ABS_spec;

val elaboration_spec =
	    AtExp.spec @
            ExpRow.spec @
            Exp.spec @
            Match.spec @
            Mrule.spec @
            Dec.spec @
            ValBind.spec @
            TypBind.spec @
            DatBind.spec @
            ConBind.spec @
            ExBind.spec @
            AtPat.spec @
            PatRow.spec @
            Ty.spec @
            TyRow.spec @
            TySeq.spec @
            Program.spec;


val drules = map (mk_drules thy) (map fst elaboration_spec); 

val sh = show drules;

fun intr s = map strip_equal (get_intr drules s);  (* Temporary fix *)

val elim = get_elim drules;

val def = get_def drules;

val thy = Merge.thy;

end;
end;
