(* -------------------------------------------------------------*)
(*								*)
(*		ConBind.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature CONBIND =
  sig
  structure DatBind: DATBIND
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor ConBindFun 
 (structure DatBind : DATBIND) : CONBIND =  
struct
structure DatBind = DatBind;
local open Syntax 
in

val spec =
    [("ConBind1",				(* Rule 30a *)
         "CE = {| (con c : t) |} <-> C, t ||- con c ~~> CE [ConBind]"),
     ("ConBind2",				(* Rule 30b *)
         "(EX t'. CE = {| (con c : t' ->> t) |} & C |- ty ~~> t' [Ty]) <-> \
       \   C, t ||- con c of ty ~~> CE [ConBind]"),
     ("ConBind3",				(* Rule 30c *)
         "(EX contypeseq. CE =  {| (con c : t), contypeseq |} & \
       \   C, t ||- conbind ~~> {| contypeseq |} [ConBind]) <-> \
       \   C, t ||- con c | conbind ~~> CE [ConBind]"),
     ("ConBind4",				(* Rule 30c *)
         "(EX t' contypeseq. CE =  {| (con c : t' ->> t), contypeseq |} & \
       \   C |- ty ~~> t' [Ty] & \
       \   C, t ||- conbind ~~> {| contypeseq |} [ConBind]) <-> \
       \   C, t ||- con c of ty | conbind ~~> CE [ConBind]")];



val thy = extend_theory DatBind.thy "CONBIND"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;

