(* -------------------------------------------------------------*)
(*								*)
(*		AtPat.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature ATPAT =
  sig
   structure ExBind: EXBIND
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor AtPatFun 
 (structure ExBind : EXBIND) : ATPAT =  
struct
structure ExBind = ExBind;
local open Syntax 
in

val spec =
    [("Wild_Pat",				(* Rule 33  *)
         "(VE = {| |}) <-> C ||- _ ~~>  (VE, t) [Pat]"),
     ("Scon_Pat",				(* -- Rule 34  *)
         "(VE = {| |} & t = int ) <-> C ||- scon n ~~> (VE, t) [Pat]"),
     ("Var_Pat",				(* Rule 35  *)
         "(VE = {| (var x : t) |}) <-> C ||- var x ~~>  (VE, t) [Pat]"),
     ("Con_Pat",				(* -- Rule 36  *)
	  "(EX SE TE EE VE s. lookup(con c, VE, s) & s > t & \
        \  C = <{| |}, {| |}, <SE, TE, VE, EE>> & VE' = {| |})  <-> \
	\  C ||- con c ~~> (VE', t) [Pat]"), 
     ("ExCon_Pat",				(* -- Rule 37  *)
	  "(EX SE TE EE VE. lookup (excon e, VE, exn) & \
        \  C = <{| |}, {| |}, <SE, TE, VE, EE>> & VE' = {| |}) <-> \
	\  C ||- excon c ~~> (VE', exn) [Pat]"), 
     ("Empty_Record_Pat",			(* Rule 38a *)
         "(VE = {| |} & t = {} inType) <-> C ||- {} ~~> (VE, t) [Pat]"),
     ("Record_Pat",				(* -- Rule 38b *)
         "C ||- patrow ~~> (VE, rectype) [PatRow]  \
        \  <-> C ||- {patrow} ~~> (VE, rectype) [Pat]"),
     ("Bracket_Pat",				(* Rule 39 *)
	"C ||- pat ~~> (VE, t) [Pat] <-> C ||- (- pat -) ~~> (VE, t) [Pat]")];


val thy = extend_theory ExBind.thy "ATPAT"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
