(* -------------------------------------------------------------*)
(*								*)
(*		AtExp.ml:					*)
(*								*)
(* ------------------------------------------------------------ *)

print_depth 1;

signature ATEXP =
  sig
   structure Obj: OBJ
  val sign: Sign.sg
  val thy: theory
  val spec :  (string * string) list
end;

functor AtExpFun 
 (structure Obj : OBJ) : ATEXP =  
struct
structure Obj = Obj;
local open Syntax 
in

val spec =
    [("Scon",					(* Rule 1 *)
        "(t = int ) <-> C |- scon n ~~> t "),
     ("Var",					(* Rule 2 *)
        "(EX VE SE TE EE s. lookup (var x, VE, s) & s > t &   \
        \  C = <{| |}, {| |}, <SE, TE, VE, EE>>) <-> \
	\  C |- var x ~~> t ") ,    
     ("Con",					(* Rule 3 *)
	"(EX VE SE TE EE s. lookup (con c, VE, s) & s > t & \
        \  C = <{| |}, {| |}, <SE, TE, VE, EE>>) <-> \
        \      C |- con  c ~~> t"),
     ("ExCon",					(* Rule 4 *)
	"(EX VE SE TE EE. lookup (excon e, VE, t)  & \
        \  C = <{| |}, {| |}, <SE, TE, VE, EE>>) <-> \
        \      C |- excon  c ~~> t"),
     ("Empty_Record",				(* Rule 5a *)
	  "t = {} inType <-> C |- {} ~~> t"),
     ("Record",					(* Rule 5b *)
	  "(EX typerow. C |- exprow ~~> typerow [ExpRow] & \
       \     t = {typerow} inType) <->   C |- {exprow} ~~> t"),
     ("Let",					(* Rule 6 *)
        "(EX E C'. C ||- d ~~> E & \
        \  COMBINE  (C,<{| |}, {| |}, E> ,C') & \
	\  C' |- e ~~>  t) <->  C |-  let d in e end ~~>  t "),
     ("Bracket",				(* Rule 7 *)
	"C |- exp ~~> t <-> C |- (- exp -) ~~> t ")];


val thy = extend_theory Obj.thy "ATEXP"
     ([], [], [], [], [], None)  spec;   

val sign = sign_of thy;

end;
end;
