;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; File: nofail.lsp
;;; System: HIPER
;;; Programmer: Jim Christian
;;; Date: April, 1989
;;; Copyright (c) 1989 by Jim Christian.  All rights reserved.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Unfailing completion.  Allow rewrites with orientable instances
;; of non-orientable equations ("pseudo-rules").

;; Rewrite only if the instance is a reduction.
(defun nofail-rewrite (ft lf-trail
			  &aux 
			  (eqn (leaf-eqn (car lf-trail)))
			  (trail (cdr lf-trail))
			  (new-term (dupl-ft-after-match (eqn-rhs eqn))))
  (restore-vars trail)
  (free-cons lf-trail)
  (if (e-greater ft new-term)
      (progn
	;(print-nofail-rewrite ft new-term eqn)
	(ft-insert ft new-term))
    (progn
      (free-ft new-term)
      nil)))

;; Another version of nofail-rewrite
(defun nofail-rewrite2 (ft trail eqn
			  &aux 
			  (new-term (dupl-ft-after-match (eqn-rhs eqn))))
  (restore-vars trail)
  (if (e-greater ft new-term)
      (progn
	;(print-nofail-rewrite ft new-term eqn)
	(ft-insert ft new-term))
    (progn
      (free-ft new-term)
      nil)))

;;  Try to find a pseudo-rule which can reduce redex.
(defun rewrite-with-pseudo-rules (redex &aux lf-trail new-redex)
  (when (setf lf-trail (net-find-lhs redex *pseudo-rules-net* *multiple-first*))
	(setf new-redex (nofail-rewrite redex lf-trail))
	(until new-redex
	       :return new-redex
	       (unless (setf lf-trail (net-find-lhs redex
						    *pseudo-rules-net*
						    *multiple-resume*))
		       (return-from rewrite-with-pseudo-rules nil))
	       (setf new-redex (nofail-rewrite redex lf-trail)))))

;; Lide rewrite-with-pseudo-rules, using E-matching.
(defun e-rewrite-with-pseudo-rules (redex &aux lf-trail new-redex)
  (when (setf lf-trail (e-net-find-lhs redex *pseudo-rules-net* *multiple-first*))
	(setf new-redex (nofail-rewrite redex lf-trail))
	(until new-redex
	       :return (progn (e-net-cleanup) new-redex)
	       (unless (setf lf-trail (e-net-find-lhs redex
						      *pseudo-rules-net*
						      *multiple-resume*))
		       (return-from e-rewrite-with-pseudo-rules nil))
	       (setf new-redex (nofail-rewrite redex lf-trail)))))

    
    
   
