;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; File: match.lsp
;;; System: HIPER
;;; Programmer: Jim Christian
;;; Date: April, 1989
;;; Copyright (c) 1989 by Jim Christian.  All rights reserved.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Matching routines.  Note that e-matching is handled implicitly
;; in the discrimination net routines ("enodes.lsp").

;; Find a substitution of the vars in t1 so that t1 = t2.
(proclaim '(function match-terms (t t) t))
(defun match-terms (t1 t2 &aux (sym 0))
  (declare (type fixnum sym))
  (with-trail
   (while t1
     :return t
     (setf sym (ft-symbol t1))
     (if (not (var? sym))
	 (unless (same-symbol? sym (ft-symbol t2))
		 (break-from-loop nil))
       (if (unbound-var? sym)
	   (progn
	     (trail sym)
	     (set-binding sym t2)
	     (setf t2 (ft-end t2)))
	 (progn
	   (unless (equal-terms (var-binding sym) t2)
		   (break-from-loop nil))
	   (setf t2 (ft-end t2)))))
     (setf t1 (ft-next t1))
     (setf t2 (ft-next t2)))))

;; Match t1 and t2, assuming that indexing has already found their
;; structure compatible.
(proclaim '(function match-vars (t t) t))
(defun match-vars (t1 t2 &aux (sym 0))
  (declare (type fixnum sym))
  (with-trail
   (while t1
     :return t
     (setf sym (ft-symbol t1))
     (when (var? sym)
	   (if (unbound-var? sym)
	       (progn (trail sym)
		      (set-binding sym t2)
		      (setf t2 (ft-end t2)))
	    (progn (unless (equal-terms (var-binding sym) t2)
			   (break-from-loop nil))
		   (setf t2 (ft-end t2)))))
     (setf t1 (ft-next t1))
     (setf t2 (ft-next t2)))))

;; Match t1 and t2, assuming that indexing has already found their
;; structure compatible.
;; This calls e-equal, instead of equal-terms.
(proclaim '(function e-match-vars (t t) t))
(defun e-match-vars (t1 t2 &aux (sym 0))
  (declare (type fixnum sym))
  (with-trail
   (while t1
     :return t
     (setf sym (ft-symbol t1))
     (when (var? sym)
	   (if (unbound-var? sym)
	       (progn (trail sym)
		      (set-binding sym t2))
	     (unless (e-equal (var-binding sym) t2)
		     (break-from-loop nil)))
	   (setf t2 (ft-end t2)))
     (setf t1 (ft-next t1))
     (setf t2 (ft-next t2)))))


;; See if t1 subsumes t2. 
(proclaim '(function subsumes (t t) t))
(defun subsumes (e1 e2 &aux tr1 tr2)
  (setf tr1 (match-terms (eqn-lhs e1) (eqn-lhs e2)))
  (when tr1
	(setf tr2 (match-terms (eqn-rhs e1) (eqn-rhs e2))))
  (when tr2
	(restore-vars tr2)
	(restore-vars tr1)
	(return-from subsumes t))
  (when tr1 (restore-vars tr1))
  nil
  )


	 
