
% checkp(+T2,+T1): T1 is an unbound "variable" v(N,X). CHeck that T2 does
% not contain prm(K) for any K>=N, and does not contain the variable X.
% Also raise the restriction on "variables" in T2 that are less restricted
% than N to N. It is assumed that T2 contains variables only in "variables".


checkp(v(M,Z), v(N,X)) :- !,
	X \== Z,
	(N < M -> Z = v(N,_); true).
checkp(prm(K), v(N,_)) :- !, K<N.
checkp(T, Var) :-
	functor(T, _, A),
	checkp(A, T, Var).

checkp(0, _, _) :- !.
checkp(I0, T, Var) :-
	arg(I0, T, A),
	nvar(A, A1),
	checkp(A1, Var),
	I is I0-1,
	checkp(I, T, Var).


% nvar(+X,-Val): Val is the value of the "variable" X. That is, X is a term
% of the form v(N1,v(N2,...v(N,Val))), where Val is either a variable or
% a term with a main functor other than v/2.

nvar(v(_,X), Val) :- nonvar(X), !, nvar(X, Val).
nvar(X, X).


% unify(+T1,+T2) - unify with occur check and parameter check and
% restriction adjustment, using "variables" for variables. When T1 and T2
% are predicate logic terms, it is presupposed that they have been reduced
% using nvar. (At top level, unify is called with predicate logic atomic
% formulas as arguments.)


unify(T1, T2) :-
	T1 = v(N1,X1),
	T2 = v(N2,X2), !,
	compare(C, N1, N2), % By the above comment, X1 and X2 are variables.
	unifyvars(C, T1, X1, T2, X2).
unify(T1, T2) :-
	T1 = v(_,X1), !,
	checkp(T2, T1),
	X1 = T2.
unify(T1, T2) :-
	T2 = v(_,X2), !,
	checkp(T1, T2),
	X2 = T1.
unify(T1, T2) :- T1 = prm(_), !, T1 = T2.
unify(T1, T2) :- atomic(T1), !, T1 = T2.
unify(T1, T2) :-
	functor(T1, N, A),
	functor(T2, N, A),
	unify(A, T1, T2).

unify(0, _, _) :- !.
unify(I0, T1, T2) :-
	arg(I0, T1, A1),
	arg(I0, T2, A2),
	nvar(A1, A11),
	nvar(A2, A22),	
	unify(A11, A22),
	I is I0-1,
	unify(I, T1, T2).

unifyvars(<, X, _, _, X).
unifyvars(=, _, X, _, X).
unifyvars(>, _, X, X, _).
