
/* There are three main predicates:

      ft(X): prove the formula X using default value 1 for all contractions.

      f(X): prove the formula X with initial default value 1 for all
      contractions, iteratively deepening the contraction
      by 1.

      pd(X): apply the decision procedure for intuitionistic propositional
      logic to decide whether X is valid. Here X is built up from
      prolog atoms using iff, imp, neg, or, and, falsum.    */




/* tprove(+X,+Qi,+Qu): attempt to prove the formula X, with default
   contraction values Qi for implications and equivalences, and
   Qu for universal formulas. tprove(+L,+X,+Qi,+Qu): similarly for
   the sequent L->X. */

tprove(X,Qi,Qu) :-
	startupflags(Flags),
	canonical(X,X1,Qi,Qu),
	iprove2(X1,[],[],[[],[]],Flags).

tprove(L,X,Qi,Qu) :-
	startupflags(Flags),
	canonical(X,X1,Qi,Qu),
	listcanonical(L,L1,Qi,Qu),
	iprove1(L1,X1,[],[],[[],[]],Flags).

% make all atomic formulas explicit, and insert default contraction values.

canonical(a(X,Y), a(Qu,X,Y1), Qi, Qu) :- !,
	canonical(Y, Y1, Qi, Qu).
canonical(a(N,X,Y), a(N,X,Y1), Qi, Qu) :- !,
	canonical(Y, Y1, Qi, Qu).
canonical(e(X,Y), e(X,Y1), Qi, Qu) :- !,
	canonical(Y, Y1, Qi, Qu).
canonical(X and Y, X1 and Y1, Qi, Qu) :- !,
	canonical(X, X1, Qi, Qu),
	canonical(Y, Y1, Qi, Qu).
canonical(X or Y, X1 or Y1, Qi, Qu) :- !,
	canonical(X, X1, Qi, Qu),
	canonical(Y, Y1, Qi, Qu).
canonical(iff(N,X,Y),iff(N,X1,Y1),Qi,Qu) :- !,
	canonical(X, X1, Qi, Qu),
	canonical(Y, Y1, Qi, Qu).
canonical(X iff Y,iff(Qi,X1,Y1), Qi, Qu) :- !,
	canonical(X, X1, Qi, Qu),
	canonical(Y, Y1, Qi, Qu).
canonical(imp(N,X,Y),imp(N,X1,Y1),Qi,Qu) :- !,
	canonical(X, X1, Qi, Qu),
	canonical(Y, Y1, Qi, Qu).
canonical(X imp Y, imp(Qi,X1,Y1), Qi, Qu) :- !,
	canonical(X, X1, Qi, Qu),
	canonical(Y, Y1, Qi, Qu).
canonical(neg X, imp(Qi,X1,falsum), Qi, Qu) :- !,
	canonical(X, X1, Qi, Qu).
canonical(falsum, falsum, Qi, Qu) :- !.
canonical(X, atom(X), Qi, Qu).

listcanonical([X|L],[Y|M],Qi,Qu) :- 
	canonical(X,Y,Qi,Qu),
	listcanonical(L,M,Qi,Qu).
listcanonical([],[],Qi,Qu).


tprove(X) :-
	tprove(X,1,1).

tprove(L,X) :-
	tprove(L,X,1,1).


ft(X,Qi,Qu) :- time(tprove(X,Qi,Qu)).
ft(L,X,Qi,Qu) :- time(tprove(L,X,Qi,Qu)).
ft(X) :- time(tprove(X)).
ft(L,X) :- time(tprove(L,X)).

/* the time predicate works for SICStus and Quintus */

time(X) :- statistics(runtime,L),X,statistics(runtime,[A,B]),flushwrite(B).
time(X) :- statistics(runtime,[A,B]),flushwrite(B),fail.

/* fi and fu below deepen the contraction only for implications/
   equivalences and universal formulas, respectively. */

f(X,N) :- time(tf(X,N)).
fi(X,N) :- time(tfi(X,N)).
fu(X,N) :- time(tfu(X,N)).
f(X) :- f(X,1).
fi(X) :- fi(X,1).
fu(X) :- fu(X,1).

tf(X,N) :- flushwrite(' '),flushwrite(N),flushwrite(' '),tprove(X,N,N).
tf(X,N) :- M is N+1,tf(X,M).

tfi(X,N) :- flushwrite(' '),flushwrite('i'),flushwrite(N),
	flushwrite(' '),tprove(X,N,1).
tfi(X,N) :- M is N+1,tfi(X,M).

tfu(X,N) :- flushwrite(' '),flushwrite('u'),flushwrite(N),
	flushwrite(' '),tprove(X,1,N).
tfu(X,N) :- M is N+1,tfu(X,M).


pd(X) :- propcheck(X,X1),time(redcon(X1,[],[],clear,clear,[])).

propcheck(A and B,A1 and B1) :- !,propcheck(A,A1),propcheck(B,B1).
propcheck(A or B,A1 or B1) :- !,propcheck(A,A1),propcheck(B,B1).
propcheck(A imp B,A1 imp B1) :- !,propcheck(A,A1),propcheck(B,B1).
propcheck(A iff B,A1 iff B1) :- !,propcheck(A,A1),propcheck(B,B1).
propcheck(neg A, A1 imp falsum) :- !,propcheck(A,A1).
propcheck(falsum,falsum) :- !.
propcheck(A,atom(A)) :- atom(A)->true;
              flushwrite('Not a propositional formula'),fail.



