
% The propositional algorithm uses Orflag, with values clear, lock, split,
% to implement both or-locking and or-or compaction. Also, implication
% locking is implemented more simply than in the predicate logic case
% by an Impflag with values clear, lock.



redant([],Imps,Atoms,Impflag,Orflag,Trans,Cons) :-
   redcon(Cons,Imps,Atoms,Impflag,Orflag,Trans).

redant([A|Ant],Imps,Atoms,Impflag,Orflag,Trans,Cons) :-
   redant(A,Ant,Imps,Atoms,Impflag,Orflag,Trans,Cons).


redant(falsum,Ant,Imps,Atoms,Impflag,Orflag,Trans,Cons).

redant(A and B,Ant,Imps,Atoms,Impflag,Orflag,Trans,Cons) :-
   redant(A,[B|Ant],Imps,Atoms,Impflag,Orflag,Trans,Cons).

redant(A or B,Ant,Imps,Atoms,Impflag,Orflag,Trans,Cons) :-
   redant(A,Ant,Imps,Atoms,Impflag,clear,Trans,Cons),
   redant(B,Ant,Imps,Atoms,Impflag,clear,Trans,Cons).

redant(A iff B,Ant,Imps,Atoms,Impflag,Orflag,Trans,Cons) :-
   redant(Ant,[A iff B|Imps],Atoms,Impflag,Orflag,Trans,Cons).

redant(A imp B,Ant,Imps,Atoms,Impflag,Orflag,Trans,Cons) :-
   redant(Ant,[A imp B|Imps],Atoms,Impflag,Orflag,Trans,Cons).

redant(atom(A),Ant,Imps,Atoms,Impflag,Orflag,Trans,atom(A)) :- !.

redant(atom(A),Ant,Imps,Atoms,Impflag,Orflag,Trans,Cons) :-
   redant(Ant,Imps,[A|Atoms],Impflag,Orflag,Trans,Cons).




redcon(A and B,Imps,Atoms,Impflag,Orflag,Trans) :-
   redcon(A,Imps,Atoms,Impflag,clear,Trans),
   redcon(B,Imps,Atoms,Impflag,clear,Trans).

redcon(A iff B,Imps,Atoms,Impflag,Orflag,Trans) :-
   redcon(A imp B,Imps,Atoms,Impflag,clear,Trans),
   redcon(B imp A,Imps,Atoms,Impflag,clear,Trans).

redcon(A imp B,Imps,Atoms,Impflag,Orflag,Trans) :- 
   memblittest(A,Trans),
   !,
   redcon(B,Imps,Atoms,Impflag,clear,Trans).
                                       
redcon(A imp B,Imps,Atoms,Impflag,Orflag,Trans) :-
   redant(A,[],Imps,Atoms,clear,clear,[A|Trans],B).

redcon(A or B,Imps,Atoms,Impflag,Orflag,Trans) :-
   Orflag\==lock,
   (redcon(A,Imps,Atoms,Impflag,split,Trans) -> true;
    redcon(B,Imps,Atoms,Impflag,split,Trans)),!.

redcon(atom(A),Imps,Atoms,Impflag,Orflag,Trans) :-
   memblittest(A,Atoms),!.

% use implication or equivalence

redcon(A or B,[Imp|Imps],Atoms,clear,Orflag,Trans) :-
   Orflag\==split,
   (containsrest(Imps,Imp,Item,Imprest),
    proveleftp(Item,Imp,Imps,Atoms,Trans)->
    proverightp(Item,Atoms,Trans,A or B,Imprest)).

redcon(atom(A),[Imp|Imps],Atoms,clear,Orflag,Trans) :-
   (containsrest(Imps,Imp,Item,Imprest),
    proveleftp(Item,Imp,Imps,Atoms,Trans)->
    proverightp(Item,Atoms,Trans,atom(A),Imprest)).

redcon(falsum,[Imp|Imps],Atoms,clear,Orflag,Trans) :-
   (containsrest(Imps,Imp,Item,Imprest),
    proveleftp(Item,Imp,Imps,Atoms,Trans)->
    proverightp(Item,Atoms,Trans,falsum,Imprest)).



proveleftp(C imp D,Imp,Imps,Atoms,Trans) :-
   redcon(C,[Imp|Imps],Atoms,lock,clear,Trans).

proveleftp(C iff D,Imp,Imps,Atoms,Trans) :-
   (redcon(C,[Imp|Imps],Atoms,lock,clear,Trans)->true;
    redcon(D,[Imp|Imps],Atoms,lock,clear,Trans)).


proverightp(C imp D,Atoms,Trans,A,Imprest) :-
   redant(D,[],Imprest,Atoms,clear,lock,Trans,A).

proverightp(C iff D,Atoms,Trans,A,Imprest) :-
   redant(C,[D],Imprest,Atoms,clear,lock,Trans,A).
   
