/* pdtrans(+N,+F): translate the predicate logic formula F, interpreted
   over the domain {a(1),...a(n)}, into a propositional formula G, and
   check the validity of G. Note: this makes sense only if F does not
   contain any individual constants or function symbols. */



pdtrans(N,F) :-
   itrans(N,F,G), % translation time not included
   time(redcon(G,[],[],clear,clear,[])).



itrans(N,F1 or F2,G1 or G2) :- !,itrans(N,F1,G1),itrans(N,F2,G2).
itrans(N,F1 and F2,G1 and G2) :- !,itrans(N,F1,G1),itrans(N,F2,G2).
itrans(N,neg F,G imp falsum) :- !,itrans(N,F,G).
itrans(N,F1 imp F2,G1 imp G2) :- !,itrans(N,F1,G1),itrans(N,F2,G2).
itrans(N,F1 iff F2,G1 iff G2) :- !,itrans(N,F1,G1),itrans(N,F2,G2).
itrans(N,a(X,F),G) :- !,itrans(N,F,H),konj(N,X,H,G).
itrans(N,e(X,F),G) :- !,itrans(N,F,H),disj(N,X,H,G).
itrans(N,P,atom(P)).


konj(1,X,H,G) :- !,psub(a(1),X,H,G).
konj(N,X,H,G) :- !,M is N-1,konj(M,X,H,GM),psub(a(N),X,H,Ga),G=(GM and Ga).

disj(1,X,H,G) :- !,psub(a(1),X,H,G).
disj(N,X,H,G) :- !,M is N-1,disj(M,X,H,GM),psub(a(N),X,H,Ga),G=(GM or Ga).

psub(T,X,X,T) :- !.
psub(T,X,FX,FT) :- !,FX =.. [P|LX],psublist(T,X,LX,LT),FT =.. [P|LT].

psublist(T,X,[FX|LX],[FT|LT]) :- psub(T,X,FX,FT),psublist(T,X,LX,LT).
psublist(T,X,[],[]).

