
iprove2(A1 and A2,Atoms,Imps,UL,Flags) :- !,
	clearcomp(Flags,Flags2),
	iprove2(A1,Atoms,Imps,UL,Flags2),
	iprove2(A2,Atoms,Imps,UL,Flags2).

iprove2(imp(N,A,B),Atoms,Imps,UL,Flags) :- !,
	clearcomp(Flags,Flags2),
	iprove2imp(A,B,Atoms,Imps,UL,Flags2).

iprove2(iff(N,A,B),Atoms,Imps,UL,Flags) :- !,
	clearcomp(Flags,Flags2),
	iprove2imp(A,B,Atoms,Imps,UL,Flags2),
	iprove2imp(B,A,Atoms,Imps,UL,Flags2).

iprove2(a(N,V,F),Atoms,Imps,UL,Flags) :- !,
	clearcomp(Flags,Flags2),
	getparam(Flags2,P,Flags1,P1),
	P1 is P+1,
	sub(F,V,prm(P),Inst),
	iprove2(Inst,Atoms,Imps,UL,Flags1).

iprove2(atom(A),[Atom|Atoms],Imps,UL,Flags) :-
	contains(Atoms,Atom,B),
	unify(B,A).

iprove2(A1 or A2,Atoms,Imps,UL,Flags) :-
	checkclearor(Flags),
	setcomp(Flags,Flags2),
	iprove2(A1,Atoms,Imps,UL,Flags2).

iprove2(A1 or A2,Atoms,Imps,UL,Flags) :-
	checkclearor(Flags),
	setcomp(Flags,Flags2),
	iprove2(A2,Atoms,Imps,UL,Flags2).

iprove2(e(V,F),Atoms,Imps,UL,Flags) :-
	checkcleare(Flags),
	setcomp(Flags,Flags2),
	getparam(Flags2,P),
	sub(F,V,v(P,W),G),
	iprove2(G,Atoms,Imps,UL,Flags2).

% atomic, exists, or, falsum.
iprove2(A,Atoms,Imps,[[Univ|Univs],U],Flags) :- 
	checkclearif(A,Flags),
	getparam(Flags,P),
	seteorif(A,Flags,Flags2),
	containsrest(Univs,Univ,Formula,Univsrest),
	alladjust(Formula,U,U1),
	Formula = a(N,V,F),
	deepinstance(P,V,F,G),  % perform allall compaction
	immcase(G,A,Atoms,Imps,[Univsrest,U1],Flags2).

% atomic, exists, or, falsum.
iprove2(A,Atoms,[Imp|Imps],UL,Flags) :- 
	checkclearif(A,Flags),
	containsrest(Imps,Imp,Item,Impsrest),
	impadjust(Item,Item1),
        proveleft(Item,Atoms,[Item1|Impsrest],UL,Flags),
        proveright(Item,A,Atoms,Impsrest,UL,Flags).

% atomic, exists, or, falsum.
iprove2(A,Atoms,Imps,[UA,UD],Flags) :-
        nonempty(UD),
        shift(UA,UD,U),
	iprove2(A,Atoms,Imps,[U,[]],Flags).

/* iprove2(A,Atoms,Imps,[UA,[U|UD]],Flags) :-
   iprove2(A,Atoms,Imps,[[U|UA],UD],Flags). */


iprove2imp(A,B,Atoms,Imps,UL,Flags) :-
	gettrans(Flags,L,Flags1,[A|L]),
	(   memblittest(A,L) ->
	    iprove2(B,Atoms,Imps,UL,Flags)
	;   removebar(Imps,Imps1),
	    iprove1(A,B,Atoms,Imps1,UL,Flags1,[])
	).

proveright(imp(N,C,D),A,Atoms,Impsrest,UL,Flags) :-
	seteorif(A,Flags,Flags2),
	iprove1(D,A,Atoms,Impsrest,UL,Flags2,[]).
proveright(iff(N,C,D),A,Atoms,Impsrest,UL,Flags) :-
	seteorif(A,Flags,Flags2),
	iprove1(C,A,Atoms,Impsrest,UL,Flags2,[D]).

proveleft(imp(N,C,D),Atoms,Imps1,UL,Flags) :-
	cleareor(Flags,Flags2),
	iprove2(C,Atoms,bar(Imps1),UL,Flags2).
proveleft(iff(N,C,D),Atoms,Imps1,UL,Flags) :-
	cleareor(Flags,Flags2),
	iprove2(C,Atoms,bar(Imps1),UL,Flags2).
proveleft(iff(N,C,D),Atoms,Imps1,UL,Flags) :-
	cleareor(Flags,Flags2),
        iprove2(D,Atoms,bar(Imps1),UL,Flags2).

% deepinstance takes care of allall compaction


deepinstance(P,V,a(_,V1,F1),G) :- !,
	deepinstance(P,V1,F1,G1),
	sub(G1,V,v(P,W),G).
deepinstance(P,V,F,G) :- sub(F,V,v(P,W),G).

% immcase deals with allimp and alliff compaction


immcase(imp(N,E1,E2),A,Atoms,Imps,UL,Flags) :- !,
	cleareor(Flags,Flags3),
        M is N-1,
        iprove2(E1,Atoms,bar([imp(M,E1,E2)|Imps]),UL,Flags3),  
	seteor(Flags,Flags4),
        iprove1(E2,A,Atoms,Imps,UL,Flags4,[]).
immcase(iff(N,E1,E2),A,Atoms,Imps,UL,Flags) :- !,
	cleareor(Flags,Flags3),
        M is N-1,
        (   iprove2(E1,Atoms,bar([iff(M,E1,E2)|Imps]),UL,Flags3)
        ;   iprove2(E2,Atoms,bar([iff(M,E1,E2)|Imps]),UL,Flags3)
        ),
	seteor(Flags,Flags4),
        iprove1(E1,A,Atoms,Imps,UL,Flags4,[E2]).
immcase(G,A,Atoms,Imps,UL,Flags) :-
	iprove1(G,A,Atoms,Imps,UL,Flags,[]).


removebar(bar(Imps), Imps) :- !.
removebar([X|Imps], [X|Imps1]) :- removebar(Imps,Imps1).
removebar([],[]).

nonempty([X|L]).

shift(UA,[],UA).
shift(UA,[X|L],M) :- shift([X|UA],L,M).


