
% iprove1(Ant,Cons,Atoms,Imps,UL,Flags)

iprove1([],Cons,Atoms,Imps,UL,Flags) :-
	iprove2(Cons,Atoms,Imps,UL,Flags).
iprove1([Ant|Ants],Cons,Atoms,Imps,UL,Flags) :-
	iprove1(Ant,Cons,Atoms,Imps,UL,Flags,Ants).


iprove1(falsum,Cons,Atoms,Imps,UL,Flags,Ant).

iprove1(A1 and A2,Cons,Atoms,Imps,UL,Flags,Ant) :- 
	iprove1(A1,Cons,Atoms,Imps,UL,Flags,[A2|Ant]).

iprove1(A1 or A2,Cons,Atoms,Imps,UL,Flags,Ant) :- 
	cleareor(Flags,Flags2),
	iprove1(A1,Cons,Atoms,Imps,UL,Flags2,Ant),
	iprove1(A2,Cons,Atoms,Imps,UL,Flags2,Ant).

iprove1(A,Cons,Atoms,Imps,UL,Flags,Ant) :-
	A = iff(N,A1,A2), 
	iprove1(Ant,Cons,Atoms,[A|Imps],UL,Flags).

iprove1(A,Cons,Atoms,Imps,UL,Flags,Ant) :-
	A = imp(N,A1,A2), 
	iprove1(Ant,Cons,Atoms,[A|Imps],UL,Flags).

iprove1(e(V,F),Cons,Atoms,Imps,UL,Flags,Ant) :- 
	cleare(Flags,Flags1),
	getparam(Flags1,P,Flags2,P1),
	P1 is P+1,
	sub(F,V,prm(P),Inst),
	iprove1(Inst,Cons,Atoms,Imps,UL,Flags2,Ant).

iprove1(A,Cons,Atoms,Imps,UL,Flags,Ant) :-
	A = a(N,V,F),
	UL = [Univs,U],
	iprove1(Ant,Cons,Atoms,Imps,[[A|Univs],U],Flags).

iprove1(atom(A),atom(C),_,_,_,_,_) :-
	unify(A,C).

iprove1(atom(A),Cons,Atoms,Imps,UL,Flags,Ant) :-
	iprove1(Ant,Cons,[A|Atoms],Imps,UL,Flags).


