
/* f(P,Trans,VEC) contains the following flags associated with each sequent:

   P is the parameter index of the sequent. When an application of
   ==>E or A==> is made, the free variable substituted for the quantified
   variable is annotated with P in the form v(P,W). At applications of
   E==> and ==>A, P is incremented in the premiss sequent.

   VEC is a number containing three bit flags: V is the or-flag and E the
   e-flag (these are used for or-locking and e-locking). C is a flag used
   to implement oror, orsome, somesome, and someor compaction. */


setor(f(P,Trans,VEC0), f(P,Trans,VEC)) :-
	VEC is VEC0 \/ 1.

clearor(f(P,Trans,VEC0), f(P,Trans,VEC)) :-
	VEC is VEC0 /\ -2.

checkclearor(f(P,Trans,VEC)) :-
	0 is VEC /\ 1.

sete(f(P,Trans,VEC0), f(P,Trans,VEC)) :-
	VEC is VEC0 \/ 2.

cleare(f(P,Trans,VEC0), f(P,Trans,VEC)) :-
	VEC is VEC0 /\ -3.

checkcleare(f(P,Trans,VEC)) :-
	0 is VEC /\ 2.

setcomp(f(P,Trans,VEC0),f(P,Trans,VEC)) :-
	VEC is VEC0 \/ 4.

clearcomp(f(P,Trans,VEC0),f(P,Trans,VEC)) :-
	VEC is VEC0 /\ -5.

checkclearcomp(f(P,Trans,VEC)) :-
	0 is VEC /\ 4.

checkclearif(A or B,f(P,Trans,VEC)) :- !,
	0 is VEC /\ 4.
checkclearif(e(X,A),f(P,Trans,VEC)) :- !,
	0 is VEC /\ 4.
checkclearif(A,Flags).

seteor(f(P,Trans,VEC0), f(P,Trans,VEC)) :-
	VEC is VEC0 \/ 3.

cleareor(f(P,Trans,VEC0), f(P,Trans,VEC)) :-
	VEC is VEC0 /\ -4.


seteorif(e(_,_),Flags,Flags1) :- !,sete(Flags,Flags1).
seteorif(_ or _,Flags,Flags1) :- !,setor(Flags,Flags1).
seteorif(A,Flags,Flags).

getparam(f(P0,Trans,VEC), P0, f(P,Trans,VEC), P).

getparam(f(P0,Trans,VEC), P0).

gettrans(f(P,Trans0,VEC), Trans0, f(P,Trans,VEC), Trans).

startupflags(f(1,[],0)).

