
:- op(700,fy,neg).
:- op(710,xfy,and).
:- op(720,xfy,or).
:- op(730,xfy,imp).
:- op(730,xfy,iff).


% These are the connectives. Quantifiers are written a(x,... and e(x,....


flushwrite(X) :-
	write(X),ttyflush.


% contains is used in checking for axioms

contains(_, X, X).
contains([Y|Ys], _, X) :- contains(Ys, Y, X).

% containsrest is used to pick an implication, equivalence, or universal
% formula to use. 

containsrest(L, X, X, L).
containsrest([Y|Ys], X0, X, [X0|L]) :- containsrest(Ys, Y, X, L).

impadjust(imp(N,C,D), imp(M,C,D)) :- N>0, M is N-1.
impadjust(iff(N,C,D), iff(M,C,D)) :- N>0, M is N-1.

% memblittest is used in transfer checking

memblittest(X,[Y|L]) :- X==Y,!;memblittest(X,L).


% sub(?TV,+V,?S,-TS): TS is the result of substituting S for every
% free occurrence of V in TV. V is prm(N) or a Prolog atom. A call to
% sub binds no variables in S or TV. The special use made of sub below
% entails that we need not check that S is free for V in TV.


sub(A,Exp,Term,A1) :- A = a(N,X,Y), !,
	(   X = Exp -> A = A1
        ;   A1 = a(N,X,Y1),
	    sub(Y, Exp, Term, Y1)
	).
sub(A,Exp,Term,A1) :- A = e(X,Y), !,
	(   X = Exp -> A = A1
        ;   A1 = e(X,Y1),
	    sub(Y, Exp, Term, Y1)
	).
sub(X and Y, Term, Exp, X1 and Y1) :- !,
	sub(X, Term, Exp, X1),
	sub(Y, Term, Exp, Y1).
sub(X or Y, Term, Exp, X1 or Y1) :- !,
	sub(X, Term, Exp, X1),
	sub(Y, Term, Exp, Y1).
sub(iff(N,X,Y), Term, Exp, iff(N,X1,Y1)) :- !,
	sub(X, Term, Exp, X1),
	sub(Y, Term, Exp, Y1).
sub(imp(N,X,Y), Term, Exp, imp(N,X1,Y1)) :- !,
	sub(X, Term, Exp, X1),
	sub(Y, Term, Exp, Y1).
sub(falsum, _, _, falsum) :- !.
sub(A, Exp, Term, A1) :- A = v(_,X), !,
	(   var(X) -> A = A1
	;   sub(X, Exp, Term, A1)
        ).
sub(A,Exp,Term,A1) :- Exp == A, !,
	Term = A1.
sub(A,Exp,Term,A1) :- A = prm(_), !,
	A = A1.
sub(X,Exp,Term,X1) :-
	functor(X, N, A),
	functor(X1, N, A),
	sub(A, X, Exp, Term, X1).

sub(0, _, _, _, _) :- !.
sub(I0, X, Exp, Term, Y) :-
	arg(I0, X, A1),
	arg(I0, Y, Y1),
	sub(A1, Exp, Term, Y1),
	I is I0-1,
	sub(I, X, Exp, Term, Y).


% alladjust(+T,+U,-U1) - reduce the contraction 
% count for T and add T to U if the reduced count is non-zero.

alladjust(a(1,_,_),U,U) :- !.
alladjust(a(N,V,F),U,[a(M,V,F)|U]) :- M is N-1.

