
#include "ft.h"


long textbuf[TEXTSIZE];

long *stack;              /* see diagram for these */
long *sp;
long *sp2;
long *sp3 = textbuf+TEXTSIZE-1;
long *sp4 = textbuf;
char *textp=(char *) textbuf;
long *fstack;
long *fsp;
long *dsp;

long *max;   /* used for checking growth of main stack */
long *fmax;
long *max3=textbuf+TEXTSIZE-1;

long stacksz=STACKSIZE*sizeof(0L);  /* NB: stacksz is size in bytes */
long fstacksz=FSTACKSIZE*sizeof(0L);

#define MAXSTACK (2000000)
#define MAXFSTACK (2000000)


/*

  The diagram shows the three data areas used (as six stacks). Textbuf[]
  is initially used to store text input and for the symbol table. sp4
  is available when the text buffer and symbol table are no longer needed.
  The analyzed formula, name tables for free input variables and function
  symbols, and the free input variables themselves are stored at the
  bottom of the stack by the functions in formula.c.



               ______________________________________________
               |sp->         STACKSIZE longs           <-sp2|  dynamic
               ----------------------------------------------
	       stack

               ______________________________________________ 
	       |sp4->        TEXTSIZE longs            <-sp3|  static
	       ----------------------------------------------
	       textbuf
	       
               ______________________________________________
	       |fsp->        FSTACKSIZE longs          <-dsp|  dynamic
	       ----------------------------------------------
	       fstack


*/






              /*************** main stack ****************/




setupstack()
{
  char *malloc();
  if ((stack=(long *)malloc((unsigned)(STACKSIZE*sizeof(0L))))==0)
    {
      printf("\nInsufficient memory\n");
      exit(0);
    }
  sp=stack;
  sp2=stack+STACKSIZE-1;
  max=stack;
}


stackreport()
{
  printf("\nmain stack use %ld\n",(max-stack)*sizeof(0L));
}


clearstack()
{
  sp=stack;
  sp2=stack+(stacksz/sizeof(0L))-1;
  max=sp;
}

stackcheck()
{
  if(sp2-sp<1000)
    return MAINOVER;
  if (sp>max)
    max=sp;
  return 1;
}


push(val)
long val;
{
  int i;
  if ((i=stackcheck())<0) return i;
  sp[0] = val;
  sp++;
  return 1;
}


long pop()
{
  sp--;
  return sp[0];
}



push2(val)
long val;
{
  int i;
  if ((i=stackcheck())<0) return i;
  sp2[0]=val;
  sp2--;
  return 1;
}


long pop2()
{
  sp2++;
  return sp2[0];
}




          /***************** auxiliary stack  ********************/




stack4check()
{
  if (sp3-sp4<1000)
    return AUXOVER;
  return 1;
}


stack3check()
{
  if (sp3-sp4<1000)
    return AUXOVER;
  if (sp3<max3)
    max3=sp3;
  return 1;
}


stack3report()
{
  printf("\nvariable stack use %ld\n",(textbuf+TEXTSIZE-max3)*sizeof(0L));
}


cleartext()
{
  sp4=textbuf;
  sp3=textbuf+TEXTSIZE-1;
  max3=sp3;
}



push3(val)
long val;
{
  int i;
  if ((i=stack3check())<0)
    return i;
  sp3[0]=val;
  sp3--;
  return 1;
}


long pop3()
{
  sp3++;
  return sp3[0];
}






                /************** formula stack ****************/



setupfstack()
{
  char *malloc();
  if ((fstack=(long *)malloc((unsigned)(FSTACKSIZE*sizeof(0L))))==0)
    {
      printf("\nInsufficient memory\n");
      exit(0);
    }
  fsp=fstack;
  dsp=fstack+FSTACKSIZE-1;
  fmax=fstack;
}



clearfstack()
{
  fsp=fstack;
  dsp=fstack+(fstacksz/sizeof(0L))-1;
  fmax=fsp;
}


fstackcheck()
{
  if(dsp-fsp<1000)
    return THIRDOVER;
  if (fsp>fmax)
    fmax=fsp;
  return 1;
}


fstackreport()
{
  printf("\nformula stack use %ld\n",(fmax-fstack)*sizeof(0L));
}


   /*************************  other stuff ******************************/



dostack(p)
     char *p;
{
  int m;
  long num,getnum();
  if (p[0]=='\0')
    {
      printf("\nMain stack size is %d bytes\n",stacksz);
      return 1;
    }
  num=getnum(p,&m);
  if (p[m])
    {
      push((long)(p+m));
      return BADSYNTAX;
    }
  if (num<STACKSIZE*sizeof(0L)||num>MAXSTACK)
    return BADSTACK;
  makestack(num);
  return 1;
}

makestack(num)
     long num;
{
  char *malloc();
  free((char *)stack);
  stacksz=num;
  if ((stack=(long *)malloc((unsigned)stacksz))==NULL)
    {
      printf("\nInsufficient memory\n");
      if ((stack=(long *)malloc((unsigned)STACKSIZE*sizeof(0L)))==NULL)
	{
	  mess("\nFatal error: can't restore old stack\n");
	  exit(0);
	}
      stacksz=STACKSIZE*sizeof(0L);
    }
  sp=stack;
  sp2=stack+(stacksz/sizeof(0L))-1;
  max=stack;
}


dofstack(p)
     char *p;
{
  int m;
  long num,getnum();
  if (p[0]=='\0')
    {
      printf("\nFormula stack size is %d bytes\n",fstacksz);
      return 1;
    }
  num=getnum(p,&m);
  if (p[m])
    {
      push((long)(p+m));
      return BADSYNTAX;
    }
  if (num<FSTACKSIZE*sizeof(0L)||num>MAXFSTACK)
    return BADSTACK;
  makefstack(num);
  return 1;
}

makefstack(num)
     long num;
{
  char *malloc();
  free((char *)fstack);
  fstacksz=num;
  if ((fstack=(long *)malloc((unsigned)fstacksz))==NULL)
    {
      printf("\nInsufficient memory\n");
      if ((fstack=(long *)malloc((unsigned)FSTACKSIZE*sizeof(0L)))==NULL)
	{
	  mess("\nFatal error: can't restore old stack\n");
	  exit(0);
	}
      fstacksz=FSTACKSIZE*sizeof(0L);
    }
  fsp=fstack;
  dsp=fstack+(fstacksz/sizeof(0L))-1;
  fmax=fstack;
}


resetstacks()
{
  makestack((long)STACKSIZE*sizeof(0L));
  makefstack((long)FSTACKSIZE*sizeof(0L));
}

  
reportstacks()
{
  stackreport();
  stack3report();
  fstackreport();
  if (twosift)
    savereport();
}



   /****************** save stacks allocation *************************/


long *freeblocks;            /* stack of freed blocks                    */
int   blockuse;              /* stack index for freeblocks[]             */
long *blocknext;             /* next unused block                        */
int   blockcount;            /* number of allocated blocks in last set   */
long  blocksets[100];        /* stack of sets                            */
int   setpoint;              /* stack index for blocksets[]              */


long blocksnum=500;          /* number of blocks in a set                */


#define SETBYTES ((unsigned)(szsave*blocksnum*sizeof(0L)))

/* SETBYTES is the total number of bytes in a set of blocks */


/* Save stacks - used when twosift is true -
   are allocated and deallocated using getblock() and freeblock(). Each
   block consists of szsave longs. Blocks are obtained using malloc()
   in sets of blocksnum blocks at a time. When a block is freed, its
   address is added to the stack freeblocks[] with index pointer blockuse.
   getblock() returns the first freed block if there is one, otherwise
   the next unused block as indicated by blocknext. If there is no
   unused block left in the current set, blocknext is set to the beginning
   of the next set, if there is one. If we are out of sets, a new set is
   requested, and the address of the new set is added to blocksets[].
   This also entails extending freeblocks[] using realloc(), to make
   room for blocksnum further blocks. */
   




setupblocks()
{
  char *malloc();
  blocknext=(long *)malloc(SETBYTES);
  freeblocks=(long *)malloc((unsigned)blocksnum*sizeof((long *)0L));
  if (blocknext==NULL||freeblocks==NULL)
    {
      printf("\nFatal memory allocation error\n");
      exit(0);
    }
  blockuse=0;
  blockcount=0;
  blocksets[0]=(long)blocknext;
  for(setpoint=1;setpoint<100;setpoint++)
    blocksets[setpoint]=NULL;
  setpoint=1;
}


resetblocks()
{
  free((char *)freeblocks);
  for(setpoint=0;setpoint<100;setpoint++)
    {
      if (blocksets[setpoint])
	free((char *)blocksets[setpoint]);
    }
  setupblocks();
}


clearblocks()
{
  blocknext=(long *)blocksets[0];
  blockuse=0;
  blockcount=0;
  setpoint=1;
}


long *getblock()
{
  long *r;
  char *realloc(),*malloc();
  if (blockuse==0)  /* there is no previously freed block */
    {
      if((r=blocknext)==NULL)
	return NULL;
      blocknext+=szsave;
      blockcount++;
      if (blockcount==blocksnum) /* we need a new set */
	{
	  if (setpoint==100)    /* 50 MB should be enough... */
	    blocknext=(long *)NULL;
	  else
	    {
	      blockcount=0;
	      if (blocksets[setpoint])
		blocknext=(long *)blocksets[setpoint++];
	      else
		{
		  blocknext=
		    (long *)malloc(SETBYTES);
		  blocksets[setpoint]=(long)blocknext;
		  setpoint++;
		  freeblocks=
		    (long *)realloc((char *)freeblocks,
			    (unsigned)(setpoint*blocksnum*sizeof(0L)));
		  if (freeblocks==(long *)NULL)
		    blocknext=(long *)NULL;
		}
	    }
	}
      return r;
    }
  /* there is a freed block */
  r=(long *)freeblocks[--blockuse];
  return r;
}


freeblock(r)
     long *r;
{
  freeblocks[blockuse++]=(long)r;
}

savereport()
{
  long n=blockcount+(setpoint-1)*blocksnum;
  printf(n==1?"\n%ld save stack used\n":"\n%ld save stacks used\n",n);
}



